/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.base.BaseExportImportPortletPreferencesProcessor;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.display.template.exportimport.portlet.preferences.processor.PortletDisplayTemplateExportCapability;
import com.liferay.portlet.display.template.exportimport.portlet.preferences.processor.PortletDisplayTemplateImportCapability;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAgreggatorPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class BlogsAggregatorExportImportPortletPreferencesProcessor
extends BaseExportImportPortletPreferencesProcessor {
    private CompanyLocalService _companyLocalService;
    private OrganizationLocalService _organizationLocalService;
    private PortletDisplayTemplateExportCapability _portletDisplayTemplateExportCapability;
    private PortletDisplayTemplateImportCapability _portletDisplayTemplateImportCapability;
    private PortletLocalService _portletLocalService;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._portletDisplayTemplateExportCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._portletDisplayTemplateImportCapability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            return this.updateExportPortletPreferences(portletDataContext, portletDataContext.getRootPortletId(), portletPreferences);
        }
        catch (Exception e) {
            return portletPreferences;
        }
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            return this.updateImportPortletPreferences(portletDataContext, portletPreferences);
        }
        catch (Exception e) {
            return portletPreferences;
        }
    }

    protected String getExportPortletPreferencesValue(PortletDataContext portletDataContext, Portlet portlet, String className, long primaryKeyLong) throws Exception {
        Organization organization;
        String uuid = null;
        Element rootElement = portletDataContext.getExportDataRootElement();
        if (className.equals(Organization.class.getName()) && (organization = this._organizationLocalService.fetchOrganization(primaryKeyLong)) != null) {
            uuid = organization.getUuid();
            portletDataContext.addReferenceElement((ClassedModel)portlet, rootElement, (ClassedModel)organization, "dependency", true);
        }
        return uuid;
    }

    protected Long getImportPortletPreferencesNewValue(PortletDataContext portletDataContext, Class<?> clazz, long companyGroupId, Map<Long, Long> primaryKeys, String portletPreferencesOldValue) throws Exception {
        Organization organization;
        if (Validator.isNumber((String)portletPreferencesOldValue)) {
            long oldPrimaryKey = GetterUtil.getLong((String)portletPreferencesOldValue);
            return MapUtil.getLong(primaryKeys, (long)oldPrimaryKey, (long)oldPrimaryKey);
        }
        String className = clazz.getName();
        if (className.equals(Organization.class.getName()) && (organization = this._organizationLocalService.fetchOrganizationByUuidAndCompanyId(portletPreferencesOldValue, portletDataContext.getCompanyId())) != null) {
            return organization.getOrganizationId();
        }
        return null;
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    protected void setOrganizationLocalService(OrganizationLocalService organizationLocalService) {
        this._organizationLocalService = organizationLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletDisplayTemplateExportCapability(PortletDisplayTemplateExportCapability portletDisplayTemplateExportCapability) {
        this._portletDisplayTemplateExportCapability = portletDisplayTemplateExportCapability;
    }

    @Reference(unbind="-")
    protected void setPortletDisplayTemplateImportCapability(PortletDisplayTemplateImportCapability portletDisplayTemplateImportCapability) {
        this._portletDisplayTemplateImportCapability = portletDisplayTemplateImportCapability;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    protected PortletPreferences updateExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long organizationId = GetterUtil.getLong((String)portletPreferences.getValue("organizationId", null));
        if (organizationId > 0L) {
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            this.updateExportPortletPreferencesClassPKs(portletDataContext, portlet, portletPreferences, "organizationId", Organization.class.getName());
        }
        return portletPreferences;
    }

    protected PortletPreferences updateImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        Company company = this._companyLocalService.getCompanyById(portletDataContext.getCompanyId());
        Group companyGroup = company.getGroup();
        this.updateImportPortletPreferencesClassPKs(portletDataContext, portletPreferences, "organizationId", Organization.class, companyGroup.getGroupId());
        return portletPreferences;
    }
}

