/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.exportimport.data.handler;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalService;
import com.liferay.blogs.kernel.service.BlogsStatsUserLocalService;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet"}, service={PortletDataHandler.class})
public class BlogsPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "blogs";
    public static final String SCHEMA_VERSION = "1.0.0";
    private BlogsEntryLocalService _blogsEntryLocalService;
    private BlogsStatsUserLocalService _blogsStatsUserLocalService;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getServiceName() {
        return "com.liferay.blogs";
    }

    @Activate
    protected void activate() {
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(BlogsEntry.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "entries", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "referenced-content")}, BlogsEntry.class.getName())});
        this.setPublishToLiveByDefault(PropsValues.BLOGS_PUBLISH_TO_LIVE_BY_DEFAULT);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(BlogsPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._blogsEntryLocalService.deleteEntries(portletDataContext.getScopeGroupId());
        this._blogsStatsUserLocalService.deleteStatsUserByGroupId(portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "entries")) {
            return this.getExportDataRootElementString(rootElement);
        }
        portletDataContext.addPortletPermissions("com.liferay.blogs");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ExportActionableDynamicQuery actionableDynamicQuery = this._blogsEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "entries")) {
            return null;
        }
        portletDataContext.importPortletPermissions("com.liferay.blogs");
        Element entriesElement = portletDataContext.getImportDataGroupElement(BlogsEntry.class);
        List entryElements = entriesElement.elements();
        for (Element entryElement : entryElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)entryElement);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ExportActionableDynamicQuery actionableDynamicQuery = this._blogsEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.performCount();
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setBlogsStatsUserLocalService(BlogsStatsUserLocalService blogsStatsUserLocalService) {
        this._blogsStatsUserLocalService = blogsStatsUserLocalService;
    }
}

