/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.asset;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalService;
import com.liferay.blogs.kernel.service.BlogsEntryService;
import com.liferay.blogs.web.asset.BlogsEntryAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.blogs.service.permission.BlogsPermission;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet"}, service={AssetRendererFactory.class})
public class BlogsEntryAssetRendererFactory
extends BaseAssetRendererFactory<BlogsEntry> {
    public static final String TYPE = "blog";
    private BlogsEntryLocalService _blogsEntryLocalService;
    private BlogsEntryService _blogsEntryService;
    @Reference
    private Portal _portal;
    private ServletContext _servletContext;

    public BlogsEntryAssetRendererFactory() {
        this.setClassName(BlogsEntry.class.getName());
        this.setLinkable(true);
        this.setPortletId("com_liferay_blogs_web_portlet_BlogsPortlet");
        this.setSearchable(true);
    }

    public AssetRenderer<BlogsEntry> getAssetRenderer(long classPK, int type) throws PortalException {
        BlogsEntry entry = this._blogsEntryLocalService.getEntry(classPK);
        BlogsEntryAssetRenderer blogsEntryAssetRenderer = new BlogsEntryAssetRenderer(entry);
        blogsEntryAssetRenderer.setAssetRendererType(type);
        blogsEntryAssetRenderer.setServletContext(this._servletContext);
        return blogsEntryAssetRenderer;
    }

    public AssetRenderer<BlogsEntry> getAssetRenderer(long groupId, String urlTitle) throws PortalException {
        BlogsEntry entry = this._blogsEntryService.getEntry(groupId, urlTitle);
        return new BlogsEntryAssetRenderer(entry);
    }

    public String getClassName() {
        return BlogsEntry.class.getName();
    }

    public String getIconCssClass() {
        return "blogs";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classTypeId) {
        PortletURL portletURL = this._portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, this.getGroup(liferayPortletRequest), "com_liferay_blogs_web_portlet_BlogsPortlet", 0L, 0L, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/blogs/edit_entry");
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_blogs_web_portlet_BlogsPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        return BlogsPermission.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_ENTRY");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return BlogsEntryPermission.contains((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.blogs.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setBlogsEntryService(BlogsEntryService blogsEntryService) {
        this._blogsEntryService = blogsEntryService;
    }
}

