/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BlogsEntryAssetRenderer
extends BaseJSPAssetRenderer<BlogsEntry>
implements TrashRenderer {
    private final BlogsEntry _entry;

    public BlogsEntryAssetRenderer(BlogsEntry entry) {
        this._entry = entry;
    }

    public BlogsEntry getAssetObject() {
        return this._entry;
    }

    public String getClassName() {
        return BlogsEntry.class.getName();
    }

    public long getClassPK() {
        return this._entry.getEntryId();
    }

    public String getDiscussionPath() {
        if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
            return "edit_entry_discussion";
        }
        return null;
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._entry.getDisplayDate();
    }

    public long getGroupId() {
        return this._entry.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/blogs/asset/" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public int getStatus() {
        return this._entry.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        String summary;
        int abstractLength = 200;
        if (portletRequest != null) {
            abstractLength = GetterUtil.getInteger((Object)portletRequest.getAttribute("ASSET_ENTRY_ABSTRACT_LENGTH"), (int)200);
        }
        if (Validator.isNull((String)(summary = this._entry.getDescription()))) {
            summary = HtmlUtil.stripHtml((String)StringUtil.shorten((String)this._entry.getContent(), (int)abstractLength));
        }
        return summary;
    }

    public String getTitle(Locale locale) {
        return this._entry.getTitle();
    }

    public String getType() {
        return "blog";
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._entry.getGroupId());
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_blogs_web_portlet_BlogsPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/blogs/edit_entry");
        portletURL.setParameter("entryId", String.valueOf(this._entry.getEntryId()));
        return portletURL;
    }

    public String getUrlTitle() {
        return this._entry.getUrlTitle();
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcRenderCommandName", "/blogs/view_entry");
        portletURL.setParameter("entryId", String.valueOf(this._entry.getEntryId()));
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/blogs/find_entry", "entryId", this._entry.getEntryId());
    }

    public long getUserId() {
        return this._entry.getUserId();
    }

    public String getUserName() {
        return this._entry.getUserName();
    }

    public String getUuid() {
        return this._entry.getUuid();
    }

    public boolean hasDeletePermission(PermissionChecker permissionChecker) {
        return BlogsEntryPermission.contains((PermissionChecker)permissionChecker, (BlogsEntry)this._entry, (String)"DELETE");
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return BlogsEntryPermission.contains((PermissionChecker)permissionChecker, (BlogsEntry)this._entry, (String)"UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return BlogsEntryPermission.contains((PermissionChecker)permissionChecker, (BlogsEntry)this._entry, (String)"VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("BLOGS_ENTRY", (Object)this._entry);
        return super.include(request, response, template);
    }

    public boolean isPrintable() {
        return true;
    }
}

