/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.test.util;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;

public class BlogsTestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlogsEntry addEntryWithWorkflow(long userId, String title, boolean approved, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            Calendar displayCalendar = CalendarFactoryUtil.getCalendar((int)2012, (int)1, (int)1);
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setWorkflowAction(2);
            BlogsEntry entry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)title, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (Date)displayCalendar.getTime(), (boolean)true, (boolean)true, (String[])new String[0], (String)"", null, null, (ServiceContext)serviceContext);
            if (approved) {
                BlogsEntry blogsEntry = BlogsTestUtil.updateStatus(entry, serviceContext);
                return blogsEntry;
            }
            BlogsEntry blogsEntry = entry;
            return blogsEntry;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public static void assertEquals(BlogsEntry expectedEntry, BlogsEntry actualEntry) {
        Assert.assertEquals((long)expectedEntry.getUserId(), (long)actualEntry.getUserId());
        Assert.assertEquals((Object)expectedEntry.getTitle(), (Object)actualEntry.getTitle());
        Assert.assertEquals((Object)expectedEntry.getDescription(), (Object)actualEntry.getDescription());
        Assert.assertEquals((Object)expectedEntry.getContent(), (Object)actualEntry.getContent());
        Assert.assertEquals((Object)expectedEntry.getDisplayDate(), (Object)actualEntry.getDisplayDate());
        Assert.assertEquals((Object)expectedEntry.isAllowPingbacks(), (Object)actualEntry.isAllowPingbacks());
        Assert.assertEquals((Object)expectedEntry.isAllowTrackbacks(), (Object)actualEntry.isAllowTrackbacks());
        Assert.assertEquals((Object)expectedEntry.isSmallImage(), (Object)actualEntry.isSmallImage());
        Assert.assertEquals((long)expectedEntry.getCoverImageFileEntryId(), (long)actualEntry.getCoverImageFileEntryId());
    }

    public static String getTempBlogsEntryAttachmentFileEntryImgTag(long dataImageId, String url) {
        return StringBundler.concat((Object[])new Object[]{"<img ", "data-image-id", "=\"", dataImageId, "\" src=\"", url, "\"/>"});
    }

    public static void populateNotificationsServiceContext(ServiceContext serviceContext, String command) throws Exception {
        serviceContext.setAttribute("entryURL", (Serializable)((Object)"http://localhost"));
        if (Validator.isNotNull((String)command)) {
            serviceContext.setCommand(command);
        }
        serviceContext.setLayoutFullURL("http://localhost");
    }

    protected static BlogsEntry updateStatus(BlogsEntry entry, ServiceContext serviceContext) throws Exception {
        return BlogsEntryLocalServiceUtil.updateStatus((long)entry.getUserId(), (long)entry.getEntryId(), (int)0, (ServiceContext)serviceContext, (Map)HashMapBuilder.put((Object)"url", (Object)"http://localhost").put((Object)"userPortraitURL", (Object)"http://localhost").put((Object)"userURL", (Object)"http://localhost").build());
    }
}

