/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.demo.internal;

import com.liferay.blogs.demo.data.creator.BlogsEntryDemoDataCreator;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.comment.demo.data.creator.MultipleCommentDemoDataCreator;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.users.admin.demo.data.creator.BasicUserDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.OmniAdminUserDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.SiteAdminUserDemoDataCreator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class BlogsDemo
extends BasePortalInstanceLifecycleListener {
    @Reference
    private BasicUserDemoDataCreator _basicUserDemoDataCreator;
    private final List<BlogsEntryDemoDataCreator> _blogsEntryDemoDataCreators = new ArrayList<BlogsEntryDemoDataCreator>();
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private MultipleCommentDemoDataCreator _multipleCommentDemoDataCreator;
    @Reference
    private OmniAdminUserDemoDataCreator _omniAdminUserDemoDataCreator;
    @Reference
    private SiteAdminUserDemoDataCreator _siteAdminUserDemoDataCreator;

    public void portalInstanceRegistered(Company company) throws Exception {
        int i;
        BlogsEntryDemoDataCreator randomBlogsEntryDemoDataCreator = this._getRandomElement(this._blogsEntryDemoDataCreators);
        User user1 = this._basicUserDemoDataCreator.create(company.getCompanyId(), "nikki.prudencio@liferay.com");
        Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
        BlogsEntry blogsEntry1 = randomBlogsEntryDemoDataCreator.create(user1.getUserId(), group.getGroupId());
        this._multipleCommentDemoDataCreator.create((ClassedModel)blogsEntry1);
        User user2 = this._omniAdminUserDemoDataCreator.create(company.getCompanyId(), "sergio.gonzalez@liferay.com");
        BlogsEntry blogsEntry2 = randomBlogsEntryDemoDataCreator.create(user2.getUserId(), group.getGroupId());
        this._multipleCommentDemoDataCreator.create((ClassedModel)blogsEntry2);
        User user3 = this._siteAdminUserDemoDataCreator.create(group.getGroupId(), "sharon.choi@liferay.com");
        BlogsEntry blogsEntry3 = randomBlogsEntryDemoDataCreator.create(user3.getUserId(), group.getGroupId());
        this._multipleCommentDemoDataCreator.create((ClassedModel)blogsEntry3);
        ArrayList<User> users = new ArrayList<User>();
        for (i = 0; i < 30; ++i) {
            users.add(this._basicUserDemoDataCreator.create(company.getCompanyId()));
        }
        for (i = 0; i < 10; ++i) {
            BlogsEntryDemoDataCreator blogsEntryDemoDataCreator = this._getRandomElement(this._blogsEntryDemoDataCreators);
            User user = (User)this._getRandomElement(users);
            BlogsEntry blogsEntry = blogsEntryDemoDataCreator.create(user.getUserId(), group.getGroupId());
            this._multipleCommentDemoDataCreator.create((ClassedModel)blogsEntry);
        }
    }

    @Deactivate
    protected void deactivate() throws PortalException {
        this._multipleCommentDemoDataCreator.delete();
        for (BlogsEntryDemoDataCreator blogsEntryDemoDataCreator : this._blogsEntryDemoDataCreators) {
            blogsEntryDemoDataCreator.delete();
        }
        this._basicUserDemoDataCreator.delete();
        this._omniAdminUserDemoDataCreator.delete();
        this._siteAdminUserDemoDataCreator.delete();
    }

    @Reference(target="(source=creative-commons)", unbind="-")
    protected void setCreativeCommonsBlogsEntryDemoDataCreator(BlogsEntryDemoDataCreator blogsEntryDemoDataCreator) {
        this._blogsEntryDemoDataCreators.add(blogsEntryDemoDataCreator);
    }

    @Reference(target="(source=lorem-ipsum)", unbind="-")
    protected void setLoremIpsumBlogsEntryDemoDataCreator(BlogsEntryDemoDataCreator blogsEntryDemoDataCreator) {
        this._blogsEntryDemoDataCreators.add(blogsEntryDemoDataCreator);
    }

    private <T> T _getRandomElement(List<T> list) {
        return list.get(RandomUtil.nextInt((int)list.size()));
    }
}

