/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.demo;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.users.admin.demo.data.creator.BasicUserDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.OmniAdminUserDemoDataCreator;
import com.liferay.users.admin.demo.data.creator.SiteAdminUserDemoDataCreator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class BlogsDemo
extends BasePortalInstanceLifecycleListener {
    private BasicUserDemoDataCreator _basicUserDemoDataCreator;
    private GroupLocalService _groupLocalService;
    private OmniAdminUserDemoDataCreator _omniAdminUserDemoDataCreator;
    private SiteAdminUserDemoDataCreator _siteAdminUserDemoDataCreator;

    public void portalInstanceRegistered(Company company) throws Exception {
        this._basicUserDemoDataCreator.create(company.getCompanyId(), "nikki.prudencio@liferay.com");
        this._omniAdminUserDemoDataCreator.create(company.getCompanyId(), "sergio.gonzalez@liferay.com");
        Group guestGroup = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
        this._siteAdminUserDemoDataCreator.create(guestGroup.getGroupId(), "sharon.choi@liferay.com");
    }

    @Deactivate
    protected void deactivate() throws PortalException {
        this._basicUserDemoDataCreator.delete();
        this._omniAdminUserDemoDataCreator.delete();
        this._siteAdminUserDemoDataCreator.delete();
    }

    @Reference(unbind="-")
    protected void setBasicUserDemoDataCreator(BasicUserDemoDataCreator basicUserDemoDataCreator) {
        this._basicUserDemoDataCreator = basicUserDemoDataCreator;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setOmniAdminUserDemoDataCreator(OmniAdminUserDemoDataCreator omniAdminUserDemoDataCreator) {
        this._omniAdminUserDemoDataCreator = omniAdminUserDemoDataCreator;
    }

    @Reference(unbind="-")
    protected void setSiteAdminUserDemoDataCreator(SiteAdminUserDemoDataCreator siteAdminUserDemoDataCreator) {
        this._siteAdminUserDemoDataCreator = siteAdminUserDemoDataCreator;
    }
}

