/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.demo.data.creator.internal;

import com.liferay.blogs.demo.data.creator.BlogsEntryDemoDataCreator;
import com.liferay.blogs.exception.NoSuchEntryException;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.document.library.demo.data.creator.FileEntryDemoDataCreator;
import com.liferay.document.library.demo.data.creator.RootFolderDemoDataCreator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseBlogsEntryDemoDataCreator
implements BlogsEntryDemoDataCreator {
    @Reference
    protected BlogsEntryLocalService blogsEntryLocalService;
    protected final List<Long> entryIds = new CopyOnWriteArrayList<Long>();
    @Reference
    protected FileEntryDemoDataCreator fileEntryDemoDataCreator;
    @Reference
    protected RootFolderDemoDataCreator rootFolderDemoDataCreator;
    private static final Log _log = LogFactoryUtil.getLog(BaseBlogsEntryDemoDataCreator.class);
    private Folder _blogsEntryImagesFolder;

    public BlogsEntry createBlogsEntry(long userId, long groupId, String title, String subtitle, String content) throws IOException, PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        ImageSelector imageSelector = new ImageSelector(this._getRandomImageBytes(userId, groupId), StringUtil.randomString() + ".jpeg", "image/jpeg", "");
        BlogsEntry blogsEntry = this.blogsEntryLocalService.addEntry(userId, title, subtitle, null, content, this._getRandomDate(), false, false, null, null, imageSelector, null, serviceContext);
        this.entryIds.add(blogsEntry.getEntryId());
        return blogsEntry;
    }

    public void delete() throws PortalException {
        for (long entryId : this.entryIds) {
            block3: {
                try {
                    this.blogsEntryLocalService.deleteEntry(entryId);
                }
                catch (NoSuchEntryException noSuchEntryException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)noSuchEntryException);
                }
            }
            this.entryIds.remove(entryId);
        }
        this.fileEntryDemoDataCreator.delete();
        this.rootFolderDemoDataCreator.delete();
    }

    private Date _getRandomDate() {
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.set(2000, 0, 1);
        long start = calendar.getTimeInMillis();
        Date date = new Date();
        long end = date.getTime();
        ThreadLocalRandom current = ThreadLocalRandom.current();
        return new Date(current.nextLong(start, end));
    }

    private byte[] _getRandomImageBytes(long userId, long groupId) throws IOException, PortalException {
        if (this._blogsEntryImagesFolder == null) {
            this._blogsEntryImagesFolder = this.rootFolderDemoDataCreator.create(userId, groupId, "Blogs Images");
        }
        FileEntry fileEntry = this.fileEntryDemoDataCreator.create(userId, this._blogsEntryImagesFolder.getFolderId());
        FileVersion fileVersion = fileEntry.getFileVersion();
        return FileUtil.getBytes((InputStream)fileVersion.getContentStream(false));
    }
}

