/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.util.comparator;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class EntryDisplayDateComparator
extends OrderByComparator<BlogsEntry> {
    public static final String ORDER_BY_ASC = "BlogsEntry.displayDate ASC, BlogsEntry.entryId ASC";
    public static final String[] ORDER_BY_CONDITION_FIELDS = new String[]{"displayDate"};
    public static final String ORDER_BY_DESC = "BlogsEntry.displayDate DESC, BlogsEntry.entryId DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"displayDate", "entryId"};
    private static final EntryDisplayDateComparator _INSTANCE_ASCENDING = new EntryDisplayDateComparator(true);
    private static final EntryDisplayDateComparator _INSTANCE_DESCENDING = new EntryDisplayDateComparator(false);
    private final boolean _ascending;

    public static EntryDisplayDateComparator getInstance(boolean ascending) {
        if (ascending) {
            return _INSTANCE_ASCENDING;
        }
        return _INSTANCE_DESCENDING;
    }

    public int compare(BlogsEntry entry1, BlogsEntry entry2) {
        int value = DateUtil.compareTo((Date)entry1.getDisplayDate(), (Date)entry2.getDisplayDate());
        if (value == 0) {
            if (entry1.getEntryId() < entry2.getEntryId()) {
                value = -1;
            } else if (entry1.getEntryId() > entry2.getEntryId()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByConditionFields() {
        return ORDER_BY_CONDITION_FIELDS;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    private EntryDisplayDateComparator(boolean ascending) {
        this._ascending = ascending;
    }
}

