/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blog.apio.internal.architect.form;

import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.BadRequestException;

public class BlogPostingForm {
    private String _alternativeHeadline;
    private String _articleBody;
    private Long _authorId;
    private Date _createDate;
    private String _description;
    private Date _displayDate;
    private String _headline;
    private String _imageCaption;
    private Long _imageId;
    private List<String> _keywords;
    private Date _modifiedDate;
    private String _semanticUrl;

    public static Form<BlogPostingForm> buildForm(Form.Builder<BlogPostingForm> formBuilder) {
        return formBuilder.title(__ -> "The blog posting form").description(__ -> "This form can be used to create or update a blog posting").constructor(BlogPostingForm::new).addOptionalDate("dateDisplayed", BlogPostingForm::_setDisplayDate).addOptionalDate("dateCreated", BlogPostingForm::_setCreateDate).addOptionalDate("dateModified", BlogPostingForm::_setModifiedDate).addOptionalLong("author", BlogPostingForm::_setAuthorId).addOptionalLong("image", BlogPostingForm::_setImageId).addOptionalString("alternativeHeadline", BlogPostingForm::_setAlternativeHeadline).addOptionalString("caption", BlogPostingForm::_setImageCaption).addOptionalString("description", BlogPostingForm::_setDescription).addOptionalString("semanticUrl", BlogPostingForm::_setSemanticUrl).addOptionalStringList("keywords", BlogPostingForm::_setKeywords).addRequiredString("articleBody", BlogPostingForm::_setArticleBody).addRequiredString("headline", BlogPostingForm::_setHeadline).build();
    }

    public String getAlternativeHeadline() {
        return Optional.ofNullable(this._alternativeHeadline).orElse("");
    }

    public String getArticleBody() {
        return this._articleBody;
    }

    public long getAuthorId(long defaultAuthorId) {
        return Optional.ofNullable(this._authorId).orElse(defaultAuthorId);
    }

    public String getDescription() {
        return Optional.ofNullable(this._description).orElse("");
    }

    public Date getDisplayDate() {
        return Optional.ofNullable(this._displayDate).orElseGet(Date::new);
    }

    public String getHeadline() {
        return this._headline;
    }

    public String getImageCaption() {
        return Optional.ofNullable(this._imageCaption).orElse("");
    }

    public ImageSelector getImageSelector(ThrowableFunction<Long, FileEntry> function) {
        if (this._imageId == null) {
            return null;
        }
        return (ImageSelector)Try.fromFallible(() -> (FileEntry)function.apply((Object)this._imageId)).map(fileEntry -> new ImageSelector(FileUtil.getBytes((InputStream)fileEntry.getContentStream()), fileEntry.getFileName(), fileEntry.getMimeType(), "{\"height\": 0,\"width\": 0,\"x\": 0,\"y\": 0}")).orElseThrow(() -> new BadRequestException("Unable to find file entry with id " + this._imageId));
    }

    public String getSemanticUrl() {
        return Optional.ofNullable(this._semanticUrl).orElse("");
    }

    public ServiceContext getServiceContext(long groupId) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        if (this._createDate != null) {
            serviceContext.setCreateDate(this._createDate);
        }
        if (this._modifiedDate != null) {
            serviceContext.setModifiedDate(this._modifiedDate);
        }
        if (ListUtil.isNotEmpty(this._keywords)) {
            serviceContext.setAssetTagNames(ArrayUtil.toStringArray(this._keywords));
        }
        return serviceContext;
    }

    private void _setAlternativeHeadline(String alternativeHeadline) {
        this._alternativeHeadline = alternativeHeadline;
    }

    private void _setArticleBody(String articleBody) {
        this._articleBody = articleBody;
    }

    private void _setAuthorId(long authorId) {
        this._authorId = authorId;
    }

    private void _setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    private void _setDescription(String description) {
        this._description = description;
    }

    private void _setDisplayDate(Date displayDate) {
        this._displayDate = displayDate;
    }

    private void _setHeadline(String headline) {
        this._headline = headline;
    }

    private void _setImageCaption(String imageCaption) {
        this._imageCaption = imageCaption;
    }

    private void _setImageId(long imageId) {
        this._imageId = imageId;
    }

    private void _setKeywords(List<String> keywords) {
        this._keywords = keywords;
    }

    private void _setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    private void _setSemanticUrl(String semanticUrl) {
        this._semanticUrl = semanticUrl;
    }
}

