/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blog.apio.internal.architect.resource;

import com.liferay.aggregate.rating.apio.architect.identifier.AggregateRatingIdentifier;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.blog.apio.architect.identifier.BlogPostingIdentifier;
import com.liferay.blog.apio.internal.architect.form.BlogPostingForm;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.model.BlogsEntryModel;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.comment.apio.architect.identifier.CommentIdentifier;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.friendly.url.exception.DuplicateFriendlyURLEntryException;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.apio.exception.ValidationException;
import com.liferay.portal.apio.idempotent.Idempotent;
import com.liferay.portal.apio.identifier.ClassNameClassPK;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.apio.user.CurrentUser;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={NestedCollectionResource.class})
public class BlogPostingNestedCollectionResource
implements NestedCollectionResource<BlogsEntry, Long, BlogPostingIdentifier, Long, ContentSpaceIdentifier> {
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference(target="(model.class.name=com.liferay.blogs.model.BlogsEntry)")
    private HasPermission<Long> _hasPermission;

    public NestedCollectionRoutes<BlogsEntry, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<BlogsEntry, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).addCreator(this::_addBlogsEntry, CurrentUser.class, this._hasPermission.forAddingIn(ContentSpaceIdentifier.class), BlogPostingForm::buildForm).build();
    }

    public String getName() {
        return "blog-posting";
    }

    public ItemRoutes<BlogsEntry, Long> itemRoutes(ItemRoutes.Builder<BlogsEntry, Long> builder) {
        return builder.addGetter(arg_0 -> ((BlogsEntryService)this._blogsEntryService).getEntry(arg_0)).addRemover(Idempotent.idempotent(arg_0 -> ((BlogsEntryService)this._blogsEntryService).deleteEntry(arg_0)), (arg_0, arg_1) -> this._hasPermission.forDeleting(arg_0, arg_1)).addUpdater(this::_updateBlogsEntry, CurrentUser.class, (arg_0, arg_1) -> this._hasPermission.forUpdating(arg_0, arg_1), BlogPostingForm::buildForm).build();
    }

    public Representor<BlogsEntry> representor(Representor.Builder<BlogsEntry, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("BlogPosting", new String[0]).identifier(BlogsEntryModel::getEntryId).addBidirectionalModel("contentSpace", "blogPosts", ContentSpaceIdentifier.class, BlogsEntryModel::getGroupId).addDate("dateCreated", BlogsEntryModel::getCreateDate)).addDate("dateModified", BlogsEntryModel::getModifiedDate)).addDate("datePublished", BlogsEntryModel::getDisplayDate)).addLinkedModel("aggregateRating", AggregateRatingIdentifier.class, ClassNameClassPK::create)).addLinkedModel("creator", PersonIdentifier.class, BlogsEntryModel::getUserId)).addLinkedModel("image", MediaObjectIdentifier.class, BlogsEntryModel::getCoverImageFileEntryId)).addRelatedCollection("category", CategoryIdentifier.class).addRelatedCollection("comment", CommentIdentifier.class).addString("alternativeHeadline", BlogsEntryModel::getSubtitle)).addString("articleBody", BlogsEntryModel::getContent)).addString("caption", BlogsEntryModel::getCoverImageCaption)).addString("description", BlogsEntryModel::getDescription)).addString("encodingFormat", blogsEntry -> "text/html")).addString("friendlyUrlPath", BlogsEntryModel::getUrlTitle)).addString("headline", BlogsEntryModel::getTitle)).addStringList("keywords", this::_getBlogsEntryAssetTags)).build();
    }

    private BlogsEntry _addBlogsEntry(long groupId, BlogPostingForm blogPostingForm, CurrentUser currentUser) throws PortalException {
        long userId = blogPostingForm.getCreatorId(currentUser.getUserId());
        ImageSelector imageSelector = blogPostingForm.getImageSelector((ThrowableFunction<Long, FileEntry>)((ThrowableFunction)arg_0 -> ((DLAppLocalService)this._dlAppLocalService).getFileEntry(arg_0)));
        ServiceContext serviceContext = blogPostingForm.getServiceContext(groupId);
        try {
            return this._blogsEntryLocalService.addEntry(userId, blogPostingForm.getHeadline(), blogPostingForm.getAlternativeHeadline(), blogPostingForm.getFriendlyURLPath(), blogPostingForm.getDescription(), blogPostingForm.getArticleBody(), blogPostingForm.getDisplayDate(), true, true, new String[0], blogPostingForm.getImageCaption(), imageSelector, null, serviceContext);
        }
        catch (DuplicateFriendlyURLEntryException dfurlee) {
            throw new ValidationException("Duplicate friendly URL", (Throwable)dfurlee);
        }
    }

    private List<String> _getBlogsEntryAssetTags(BlogsEntry blogsEntry) {
        List assetTags = this._assetTagLocalService.getTags(BlogsEntry.class.getName(), blogsEntry.getEntryId());
        return ListUtil.toList((List)assetTags, AssetTagModel::getName);
    }

    private PageItems<BlogsEntry> _getPageItems(Pagination pagination, long contentSpaceId) {
        List blogsEntries = this._blogsEntryService.getGroupEntries(contentSpaceId, 0, pagination.getStartPosition(), pagination.getEndPosition());
        int count = this._blogsEntryService.getGroupEntriesCount(contentSpaceId, 0);
        return new PageItems((Collection)blogsEntries, count);
    }

    private BlogsEntry _updateBlogsEntry(long blogsEntryId, BlogPostingForm blogPostingForm, CurrentUser currentUser) throws PortalException {
        long userId = blogPostingForm.getCreatorId(currentUser.getUserId());
        ImageSelector imageSelector = blogPostingForm.getImageSelector((ThrowableFunction<Long, FileEntry>)((ThrowableFunction)arg_0 -> ((DLAppLocalService)this._dlAppLocalService).getFileEntry(arg_0)));
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogsEntryId);
        ServiceContext serviceContext = blogPostingForm.getServiceContext(blogsEntry.getGroupId());
        return this._blogsEntryLocalService.updateEntry(userId, blogsEntryId, blogPostingForm.getHeadline(), blogPostingForm.getAlternativeHeadline(), blogPostingForm.getFriendlyURLPath(), blogPostingForm.getDescription(), blogPostingForm.getArticleBody(), blogPostingForm.getDisplayDate(), true, true, new String[0], blogPostingForm.getImageCaption(), imageSelector, null, serviceContext);
    }
}

