/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blog.apio.internal.architect.form;

import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.BadRequestException;

public class BlogPostingForm {
    private String _alternativeHeadline;
    private String _articleBody;
    private List<Long> _categories;
    private Date _createDate;
    private Long _creatorId;
    private String _description;
    private Date _displayDate;
    private String _friendlyURLPath;
    private String _headline;
    private String _imageCaption;
    private Long _imageId;
    private List<String> _keywords;
    private Date _modifiedDate;

    public static Form<BlogPostingForm> buildForm(Form.Builder<BlogPostingForm> formBuilder) {
        return formBuilder.title(__ -> "The blog posting form").description(__ -> "This form can be used to create or update a blog posting").constructor(BlogPostingForm::new).addOptionalDate("dateDisplayed", BlogPostingForm::setDisplayDate).addOptionalDate("dateCreated", BlogPostingForm::setCreateDate).addOptionalDate("dateModified", BlogPostingForm::setModifiedDate).addOptionalLinkedModel("creator", PersonIdentifier.class, BlogPostingForm::setCreatorId).addOptionalLinkedModel("image", MediaObjectIdentifier.class, BlogPostingForm::setImageId).addOptionalLinkedModelList("category", CategoryIdentifier.class, BlogPostingForm::setCategories).addOptionalString("alternativeHeadline", BlogPostingForm::setAlternativeHeadline).addOptionalString("caption", BlogPostingForm::setImageCaption).addOptionalString("description", BlogPostingForm::setDescription).addOptionalString("friendlyUrlPath", BlogPostingForm::setFriendlyURLPath).addOptionalStringList("keywords", BlogPostingForm::setKeywords).addRequiredString("articleBody", BlogPostingForm::setArticleBody).addRequiredString("headline", BlogPostingForm::setHeadline).build();
    }

    public String getAlternativeHeadline() {
        return Optional.ofNullable(this._alternativeHeadline).orElse("");
    }

    public String getArticleBody() {
        return this._articleBody;
    }

    public long getCreatorId(long defaultCreatorId) {
        return Optional.ofNullable(this._creatorId).orElse(defaultCreatorId);
    }

    public String getDescription() {
        return Optional.ofNullable(this._description).orElse("");
    }

    public Date getDisplayDate() {
        return Optional.ofNullable(this._displayDate).orElseGet(Date::new);
    }

    public String getFriendlyURLPath() {
        return Optional.ofNullable(this._friendlyURLPath).orElse("");
    }

    public String getHeadline() {
        return this._headline;
    }

    public String getImageCaption() {
        return Optional.ofNullable(this._imageCaption).orElse("");
    }

    public ImageSelector getImageSelector(ThrowableFunction<Long, FileEntry> function) {
        if (this._imageId == null) {
            return null;
        }
        return (ImageSelector)Try.fromFallible(() -> (FileEntry)function.apply((Object)this._imageId)).map(fileEntry -> new ImageSelector(FileUtil.getBytes((InputStream)fileEntry.getContentStream()), fileEntry.getFileName(), fileEntry.getMimeType(), "{\"height\": 0,\"width\": 0,\"x\": 0,\"y\": 0}")).orElseThrow(() -> new BadRequestException("Unable to find file entry with id " + this._imageId));
    }

    public ServiceContext getServiceContext(long groupId) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        if (this._createDate != null) {
            serviceContext.setCreateDate(this._createDate);
        }
        if (this._modifiedDate != null) {
            serviceContext.setModifiedDate(this._modifiedDate);
        }
        if (ListUtil.isNotEmpty(this._keywords)) {
            serviceContext.setAssetTagNames(ArrayUtil.toStringArray(this._keywords));
        }
        if (ListUtil.isNotEmpty(this._categories)) {
            serviceContext.setAssetCategoryIds(ArrayUtil.toLongArray(this._categories));
        }
        return serviceContext;
    }

    public void setAlternativeHeadline(String alternativeHeadline) {
        this._alternativeHeadline = alternativeHeadline;
    }

    public void setArticleBody(String articleBody) {
        this._articleBody = articleBody;
    }

    public void setCategories(List<Long> categories) {
        this._categories = categories;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    public void setCreatorId(long creatorId) {
        this._creatorId = creatorId;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setDisplayDate(Date displayDate) {
        this._displayDate = displayDate;
    }

    public void setFriendlyURLPath(String friendlyURLPath) {
        this._friendlyURLPath = friendlyURLPath;
    }

    public void setHeadline(String headline) {
        this._headline = headline;
    }

    public void setImageCaption(String imageCaption) {
        this._imageCaption = imageCaption;
    }

    public void setImageId(long imageId) {
        this._imageId = imageId;
    }

    public void setKeywords(List<String> keywords) {
        this._keywords = keywords;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }
}

