/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.registration.internal;

import com.liferay.bean.portlet.extension.BeanFilterMethodFactory;
import com.liferay.bean.portlet.extension.BeanFilterMethodInvoker;
import com.liferay.bean.portlet.extension.BeanPortletMethodInvoker;
import com.liferay.bean.portlet.registration.internal.BeanApp;
import com.liferay.bean.portlet.registration.internal.BeanFilter;
import com.liferay.bean.portlet.registration.internal.BeanFilterInvokerPortletFilter;
import com.liferay.bean.portlet.registration.internal.BeanPortlet;
import com.liferay.bean.portlet.registration.internal.BeanPortletInvokerPortlet;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.portlet.Portlet;
import javax.portlet.filter.PortletFilter;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;

public class RegistrationUtil {
    private static final Log _log = LogFactoryUtil.getLog(RegistrationUtil.class);

    public static void registerBeanFilter(Set<String> allPortletNames, BeanFilter beanFilter, BeanFilterMethodFactory beanFilterMethodFactory, BeanFilterMethodInvoker beanFilterMethodInvoker, BundleContext bundleContext, String portletName, List<ServiceRegistration<?>> serviceRegistrations, ServletContext servletContext) {
        if (Objects.equals(portletName, "*")) {
            for (String curPortletName : allPortletNames) {
                serviceRegistrations.add(RegistrationUtil._registerBeanFilter(beanFilter, beanFilterMethodFactory, beanFilterMethodInvoker, bundleContext, RegistrationUtil._getPortletId(curPortletName, servletContext.getServletContextName())));
            }
        } else if (!allPortletNames.contains(portletName)) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to register filter ", beanFilter.getFilterName(), " for nonexistent portlet ", portletName}));
        } else {
            serviceRegistrations.add(RegistrationUtil._registerBeanFilter(beanFilter, beanFilterMethodFactory, beanFilterMethodInvoker, bundleContext, RegistrationUtil._getPortletId(portletName, servletContext.getServletContextName())));
        }
        ArrayList<String> beanFilterNames = (ArrayList<String>)servletContext.getAttribute("BEAN_FILTER_NAMES");
        if (beanFilterNames == null) {
            beanFilterNames = new ArrayList<String>();
            servletContext.setAttribute("BEAN_FILTER_NAMES", beanFilterNames);
        }
        beanFilterNames.add(beanFilter.getFilterName());
    }

    public static ServiceRegistration<Portlet> registerBeanPortlet(BeanApp beanApp, BeanPortlet beanPortlet, List<String> beanPortletIds, BeanPortletMethodInvoker beanPortletMethodInvoker, BundleContext bundleContext, ServletContext servletContext) {
        try {
            String portletId = RegistrationUtil._getPortletId(beanPortlet.getPortletName(), servletContext.getServletContextName());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Registering bean portlet " + portletId));
            }
            Dictionary<String, Object> dictionary = beanPortlet.toDictionary(beanApp);
            dictionary.put("javax.portlet.name", portletId);
            Bundle bundle = bundleContext.getBundle();
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            ServiceRegistration portletServiceRegistration = bundleContext.registerService(Portlet.class, (Object)new BeanPortletInvokerPortlet(beanPortlet.getBeanMethods(), beanPortletMethodInvoker, bundleWiring.getClassLoader()), dictionary);
            beanPortletIds.add(portletId);
            return portletServiceRegistration;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }

    public static ServiceRegistration<ResourceBundleLoader> registerResourceBundleLoader(BeanPortlet beanPortlet, BundleContext bundleContext, ServletContext servletContext) {
        String resourceBundle = beanPortlet.getResourceBundle();
        if (Validator.isNull((String)resourceBundle)) {
            return null;
        }
        ClassResourceBundleLoader resourceBundleLoader = new ClassResourceBundleLoader(resourceBundle, servletContext.getClassLoader());
        return bundleContext.registerService(ResourceBundleLoader.class, (Object)resourceBundleLoader, (Dictionary)HashMapDictionaryBuilder.put((Object)"resource.bundle.base.name", (Object)resourceBundle).put((Object)"service.ranking", (Object)Integer.MIN_VALUE).put((Object)"servlet.context.name", (Object)servletContext.getServletContextName()).build());
    }

    private static String _getPortletId(String portletName, String servletContextName) {
        if (Validator.isNotNull((String)servletContextName)) {
            portletName = StringBundler.concat((String[])new String[]{portletName, "_WAR_", servletContextName});
        }
        return PortalUtil.getJsSafePortletId((String)portletName);
    }

    private static ServiceRegistration<PortletFilter> _registerBeanFilter(BeanFilter beanFilter, BeanFilterMethodFactory beanFilterMethodFactory, BeanFilterMethodInvoker beanFilterMethodInvoker, BundleContext bundleContext, String portletId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Registering bean filter ", beanFilter.getFilterName(), " for portlet ", portletId}));
        }
        Dictionary<String, Object> dictionary = beanFilter.toDictionary();
        dictionary.put("javax.portlet.name", portletId);
        return bundleContext.registerService(PortletFilter.class, (Object)new BeanFilterInvokerPortletFilter(beanFilterMethodFactory, beanFilterMethodInvoker, beanFilter.getFilterClass()), dictionary);
    }
}

