/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bean.portlet.registration.internal.xml;

import com.liferay.bean.portlet.extension.BeanPortletMethod;
import com.liferay.bean.portlet.extension.BeanPortletMethodFactory;
import com.liferay.bean.portlet.extension.BeanPortletMethodType;
import com.liferay.bean.portlet.registration.internal.BeanApp;
import com.liferay.bean.portlet.registration.internal.BeanAppImpl;
import com.liferay.bean.portlet.registration.internal.BeanFilter;
import com.liferay.bean.portlet.registration.internal.BeanFilterImpl;
import com.liferay.bean.portlet.registration.internal.BeanPortlet;
import com.liferay.bean.portlet.registration.internal.BeanPortletImpl;
import com.liferay.bean.portlet.registration.internal.Event;
import com.liferay.bean.portlet.registration.internal.EventImpl;
import com.liferay.bean.portlet.registration.internal.MultipartConfig;
import com.liferay.bean.portlet.registration.internal.PortletDependency;
import com.liferay.bean.portlet.registration.internal.Preference;
import com.liferay.bean.portlet.registration.internal.PublicRenderParameter;
import com.liferay.bean.portlet.registration.internal.PublicRenderParameterImpl;
import com.liferay.bean.portlet.registration.internal.util.BeanMethodIndexUtil;
import com.liferay.bean.portlet.registration.internal.util.PortletScannerUtil;
import com.liferay.bean.portlet.registration.internal.xml.PortletQNameUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.portlet.filter.PortletFilter;
import javax.xml.namespace.QName;
import org.osgi.framework.Bundle;

public class PortletDescriptorParser {
    private static final String _ENGLISH_EN = LocaleUtil.ENGLISH.getLanguage();
    private static final boolean _PORTLET_XML_VALIDATE = GetterUtil.getBoolean((String)PropsUtil.get((String)"portlet.xml.validate"));
    private static final Log _log = LogFactoryUtil.getLog(PortletDescriptorParser.class);

    public static BeanApp parse(Map<String, BeanFilter> beanFilters, BeanPortletMethodFactory beanPortletMethodFactory, Map<String, BeanPortlet> beanPortlets, Bundle bundle, Map<String, String> displayDescriptorCategories, Map<String, Map<String, Set<String>>> liferayConfigurations, Function<String, Set<BeanPortletMethod>> portletBeanMethodsFunction, URL portletDescriptorURL, Function<String, String> preferencesValidatorFunction) throws DocumentException {
        Document document = UnsecureSAXReaderUtil.read((URL)portletDescriptorURL, (boolean)_PORTLET_XML_VALIDATE);
        Element rootElement = document.getRootElement();
        BeanApp beanApp = PortletDescriptorParser._readBeanApp(rootElement);
        PortletDescriptorParser._populateBeanFilters(beanFilters, bundle, rootElement);
        PortletDescriptorParser._populateBeanPortlets(beanApp, beanPortlets, bundle, beanPortletMethodFactory, displayDescriptorCategories, liferayConfigurations, portletBeanMethodsFunction, preferencesValidatorFunction, rootElement);
        return beanApp;
    }

    private static boolean _isCustomPortletMode(String portletModeName) {
        return PortalUtil.isCustomPortletMode((PortletMode)new PortletMode(portletModeName));
    }

    private static void _populateBeanFilters(Map<String, BeanFilter> beanFilters, Bundle bundle, Element rootElement) {
        HashMap filterMappings = new HashMap();
        for (Element filterMappingElement : rootElement.elements("filter-mapping")) {
            String filterName = filterMappingElement.elementText("filter-name");
            HashSet<String> portletNames = new HashSet<String>();
            for (Element portletNameElement : filterMappingElement.elements("portlet-name")) {
                portletNames.add(portletNameElement.getTextTrim());
            }
            filterMappings.put(filterName, portletNames);
        }
        for (Element filterElement : rootElement.elements("filter")) {
            Class filterClass;
            block6: {
                String filterClassName = filterElement.elementText("filter-class");
                filterClass = null;
                try {
                    filterClass = bundle.loadClass(filterClassName);
                    if (!PortletFilter.class.isAssignableFrom(filterClass)) {
                        _log.error((Object)StringBundler.concat((Object[])new Object[]{"Ignoring ", filterClass, ". Because it does not implement ", PortletFilter.class}));
                    }
                    break block6;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    _log.error((Object)("Unable to load filter-class " + filterClassName));
                }
                continue;
            }
            String filterName = filterElement.elementText("filter-name");
            Set portletNames = (Set)filterMappings.get(filterName);
            beanFilters.put(filterName, PortletDescriptorParser._readBeanFilter(filterClass.asSubclass(PortletFilter.class), filterElement, filterName, portletNames));
        }
    }

    private static void _populateBeanPortlets(BeanApp beanApp, Map<String, BeanPortlet> beanPortlets, Bundle bundle, BeanPortletMethodFactory beanPortletMethodFactory, Map<String, String> displayDescriptorCategories, Map<String, Map<String, Set<String>>> liferayConfigurations, Function<String, Set<BeanPortletMethod>> portletBeanMethodsFunction, Function<String, String> preferencesValidatorFunction, Element rootElement) {
        for (Element portletElement : rootElement.elements("portlet")) {
            String portletClassName = GetterUtil.getString((String)portletElement.elementText("portlet-class"));
            Class portletClass = null;
            try {
                portletClass = bundle.loadClass(portletClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                _log.error((Object)("Unable to load portlet-class " + portletClassName));
                continue;
            }
            String portletName = portletElement.elementText("portlet-name");
            HashSet<BeanPortletMethod> beanPortletMethods = new HashSet<BeanPortletMethod>((Collection)portletBeanMethodsFunction.apply(portletName));
            PortletScannerUtil.scanNonannotatedBeanMethods(portletClass, beanPortletMethodFactory, beanPortletMethods);
            Map<BeanPortletMethodType, List<BeanPortletMethod>> beanMethodMap = BeanMethodIndexUtil.indexBeanMethods(beanPortletMethods);
            String preferencesValidator = preferencesValidatorFunction.apply(portletName);
            String categoryName = displayDescriptorCategories.get(portletName);
            Map<String, Set<String>> liferayConfiguration = liferayConfigurations.get(portletName);
            beanPortlets.put(portletName, PortletDescriptorParser._readBeanPortlet(beanApp, beanMethodMap, categoryName, liferayConfiguration, portletClassName, portletElement, portletName, preferencesValidator));
        }
    }

    private static BeanApp _readBeanApp(Element rootElement) {
        String specVersion = GetterUtil.get((String)rootElement.attributeValue("version"), (String)"3.0");
        String defaultNamespace = rootElement.elementText("default-namespace");
        ArrayList<Event> events = new ArrayList<Event>();
        for (Object eventDefinitionElement : rootElement.elements("event-definition")) {
            Element qNameElement = eventDefinitionElement.element("qname");
            Element nameElement = eventDefinitionElement.element("name");
            QName qName = PortletQNameUtil.getQName(defaultNamespace, qNameElement, nameElement);
            String valueType = eventDefinitionElement.elementText("value-type");
            List aliases = eventDefinitionElement.elements("alias");
            ArrayList<QName> aliasQNames = new ArrayList<QName>(aliases.size());
            for (Element alias : aliases) {
                aliasQNames.add(PortletQNameUtil.getQName(defaultNamespace, alias, null));
            }
            events.add(new EventImpl(aliasQNames, qName, valueType));
        }
        HashMap<String, PublicRenderParameter> publicRenderParameters = new HashMap<String, PublicRenderParameter>();
        for (Object publicRenderParameterElement : rootElement.elements("public-render-parameter")) {
            String identifier = publicRenderParameterElement.elementText("identifier");
            Element qNameElement = publicRenderParameterElement.element("qname");
            Element nameElement = publicRenderParameterElement.element("name");
            QName qName = PortletQNameUtil.getQName(defaultNamespace, qNameElement, nameElement);
            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(identifier, qName);
            publicRenderParameters.put(identifier, publicRenderParameter);
        }
        HashMap<String, List<String>> containerRuntimeOptions = new HashMap<String, List<String>>();
        for (Object containerRuntimeOptionElement : rootElement.elements("container-runtime-option")) {
            String name = GetterUtil.getString((String)containerRuntimeOptionElement.elementText("name"));
            ArrayList<String> values = new ArrayList<String>();
            for (Element valueElement : containerRuntimeOptionElement.elements("value")) {
                values.add(valueElement.getTextTrim());
            }
            containerRuntimeOptions.put(name, values);
        }
        HashSet<String> validCustomPortletModes = new HashSet<String>();
        for (Element customPortletModeElement : rootElement.elements("custom-portlet-mode")) {
            String portletMode = StringUtil.toLowerCase((String)customPortletModeElement.elementTextTrim("portlet-mode"));
            boolean portalManaged = Boolean.valueOf(customPortletModeElement.elementText("portal-managed"));
            if (PortletDescriptorParser._isCustomPortletMode(portletMode) && portalManaged) continue;
            validCustomPortletModes.add(portletMode);
        }
        ArrayList<Map.Entry<Integer, String>> portletListeners = new ArrayList<Map.Entry<Integer, String>>();
        for (Element listenerElement : rootElement.elements("listener")) {
            int ordinal = GetterUtil.getInteger((String)listenerElement.elementText("ordinal"));
            String listenerClassName = listenerElement.elementText("listener-class");
            portletListeners.add(new AbstractMap.SimpleImmutableEntry<Integer, String>(ordinal, listenerClassName));
        }
        return new BeanAppImpl(containerRuntimeOptions, validCustomPortletModes, defaultNamespace, events, portletListeners, publicRenderParameters, specVersion);
    }

    private static BeanFilter _readBeanFilter(Class<? extends PortletFilter> filterClass, Element filterElement, String filterName, Set<String> portletNames) {
        int ordinal = GetterUtil.getInteger((String)filterElement.elementText("ordinal"));
        LinkedHashSet<String> lifecycles = new LinkedHashSet<String>();
        for (Element lifecycleElement : filterElement.elements("lifecycle")) {
            lifecycles.add(lifecycleElement.getText());
        }
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (Element initParamElement : filterElement.elements("init-param")) {
            initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
        }
        return new BeanFilterImpl(filterClass, filterName, initParams, lifecycles, ordinal, portletNames);
    }

    private static BeanPortlet _readBeanPortlet(BeanApp beanApp, Map<BeanPortletMethodType, List<BeanPortletMethod>> beanMethodMap, String categoryName, Map<String, Set<String>> liferayConfiguration, String portletClassName, Element portletElement, String portletName, String preferencesValidator) {
        Map<String, String> displayNames = PortletDescriptorParser._toLocaleMap(portletElement.elements("display-name"));
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (Element initParamElement : portletElement.elements("init-param")) {
            initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
        }
        int expirationCache = 0;
        Element expirationCacheElement = portletElement.element("expiration-cache");
        if (expirationCacheElement != null) {
            expirationCache = GetterUtil.getInteger((String)expirationCacheElement.getText());
        }
        HashMap<String, Set<String>> supportedPortletModes = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> supportedWindowStates = new HashMap<String, Set<String>>();
        Set<String> validCustomPortletModes = beanApp.getCustomPortletModes();
        for (Object supportsElement : portletElement.elements("supports")) {
            String mimeType = supportsElement.elementText("mime-type");
            HashSet<String> mimeTypePortletModes = new HashSet<String>();
            mimeTypePortletModes.add(PortletMode.VIEW.toString());
            for (Element portletModeElement : supportsElement.elements("portlet-mode")) {
                String portletMode = StringUtil.toLowerCase((String)portletModeElement.getTextTrim());
                if (PortletDescriptorParser._isCustomPortletMode(portletMode) && !validCustomPortletModes.contains(portletMode)) continue;
                mimeTypePortletModes.add(portletMode);
            }
            supportedPortletModes.put(mimeType, mimeTypePortletModes);
            HashSet<String> mimeTypeWindowStates = new HashSet<String>();
            mimeTypeWindowStates.add(WindowState.NORMAL.toString());
            List windowStateElements = supportsElement.elements("window-state");
            if (windowStateElements.isEmpty()) {
                mimeTypeWindowStates.add(WindowState.MAXIMIZED.toString());
                mimeTypeWindowStates.add(WindowState.MINIMIZED.toString());
                mimeTypeWindowStates.add(LiferayWindowState.EXCLUSIVE.toString());
                mimeTypeWindowStates.add(LiferayWindowState.POP_UP.toString());
            } else {
                for (Element windowStateElement : windowStateElements) {
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)windowStateElement.getTextTrim()));
                }
            }
            supportedWindowStates.put(mimeType, mimeTypeWindowStates);
        }
        HashSet<String> supportedLocales = new HashSet<String>();
        for (Element supportedLocaleElement : portletElement.elements("supported-locale")) {
            String supportedLocale = supportedLocaleElement.getText();
            supportedLocales.add(supportedLocale);
        }
        String resourceBundle = portletElement.elementText("resource-bundle");
        Element portletInfoElement = portletElement.element("portlet-info");
        Map<String, String> titles = Collections.emptyMap();
        Map<String, String> shortTitles = Collections.emptyMap();
        Map<String, String> keywords = Collections.emptyMap();
        Map<String, String> descriptions = Collections.emptyMap();
        if (portletInfoElement != null) {
            titles = PortletDescriptorParser._toLocaleMap(portletInfoElement.elements("title"));
            shortTitles = PortletDescriptorParser._toLocaleMap(portletInfoElement.elements("short-title"));
            keywords = PortletDescriptorParser._toLocaleMap(portletInfoElement.elements("keywords"));
            descriptions = PortletDescriptorParser._toLocaleMap(portletInfoElement.elements("description"));
        }
        HashMap<String, Preference> preferences = new HashMap<String, Preference>();
        Element portletPreferencesElement = portletElement.element("portlet-preferences");
        if (portletPreferencesElement != null) {
            for (Element preferenceElement : portletPreferencesElement.elements("preference")) {
                String name = preferenceElement.elementText("name");
                ArrayList<String> values = new ArrayList<String>();
                List valueElements = preferenceElement.elements("value");
                if (valueElements != null) {
                    for (Element valueElement : valueElements) {
                        values.add(valueElement.getText());
                    }
                }
                preferences.put(name, new Preference(GetterUtil.getBoolean((String)preferenceElement.elementText("read-only")), values));
            }
            String xmlPreferencesValidator = portletPreferencesElement.elementText("preferences-validator");
            if (xmlPreferencesValidator != null) {
                preferencesValidator = xmlPreferencesValidator;
            }
        }
        HashMap<String, String> securityRoleRefs = new HashMap<String, String>();
        for (Object roleElement : portletElement.elements("security-role-ref")) {
            securityRoleRefs.put(roleElement.elementText("role-name"), roleElement.elementText("role-link"));
        }
        HashSet<QName> supportedProcessingEvents = new HashSet<QName>();
        for (Object supportedProcessingEventElement : portletElement.elements("supported-processing-event")) {
            Element qNameElement = supportedProcessingEventElement.element("qname");
            Element nameElement = supportedProcessingEventElement.element("name");
            QName qName = PortletQNameUtil.getQName(beanApp.getDefaultNamespace(), qNameElement, nameElement);
            supportedProcessingEvents.add(qName);
        }
        HashSet<QName> supportedPublishingEvents = new HashSet<QName>();
        for (Element supportedPublishingEventElement : portletElement.elements("supported-publishing-event")) {
            Element qNameElement = supportedPublishingEventElement.element("qname");
            Element nameElement = supportedPublishingEventElement.element("name");
            QName qName = PortletQNameUtil.getQName(beanApp.getDefaultNamespace(), qNameElement, nameElement);
            supportedPublishingEvents.add(qName);
        }
        BeanMethodIndexUtil.scanSupportedEvents(beanMethodMap, supportedProcessingEvents, supportedPublishingEvents);
        Map<String, PublicRenderParameter> publicRenderParameters = beanApp.getPublicRenderParameters();
        HashSet<String> supportedPublicRenderParameters = new HashSet<String>();
        for (Object supportedPublicRenderParameter : portletElement.elements("supported-public-render-parameter")) {
            String identifier = supportedPublicRenderParameter.getTextTrim();
            PublicRenderParameter publicRenderParameter = publicRenderParameters.get(identifier);
            if (publicRenderParameter == null && _log.isWarnEnabled()) {
                _log.warn((Object)("Supported public render parameter references unknown identifier " + identifier));
            }
            supportedPublicRenderParameters.add(identifier);
        }
        HashMap<String, List<String>> containerRuntimeOptions = new HashMap<String, List<String>>(beanApp.getContainerRuntimeOptions());
        for (Object containerRuntimeOptionElement : portletElement.elements("container-runtime-option")) {
            String name = GetterUtil.getString((String)containerRuntimeOptionElement.elementText("name"));
            ArrayList<String> values = new ArrayList<String>();
            for (Element valueElement : containerRuntimeOptionElement.elements("value")) {
                values.add(valueElement.getTextTrim());
            }
            containerRuntimeOptions.put(name, values);
        }
        HashSet<PortletDependency> portletDependencies = new HashSet<PortletDependency>();
        for (Element dependencyElement : portletElement.elements("dependency")) {
            String name = GetterUtil.getString((String)dependencyElement.elementText("name"));
            String scope = GetterUtil.getString((String)dependencyElement.elementText("scope"));
            String version = GetterUtil.getString((String)dependencyElement.elementText("version"));
            portletDependencies.add(new PortletDependency(name, scope, version));
        }
        boolean asyncSupported = GetterUtil.getBoolean((String)portletElement.elementText("async-supported"));
        MultipartConfig multipartConfig = MultipartConfig.UNSUPPORTED;
        Element multipartConfigElement = portletElement.element("multipart-config");
        if (multipartConfigElement != null) {
            multipartConfig = new MultipartConfig(GetterUtil.getInteger((String)multipartConfigElement.elementText("file-size-threshold")), multipartConfigElement.elementText("location"), GetterUtil.getLong((String)multipartConfigElement.elementText("max-file-size"), (long)-1L), GetterUtil.getLong((String)multipartConfigElement.elementText("max-request-size"), (long)-1L));
        }
        return new BeanPortletImpl(asyncSupported, beanMethodMap, containerRuntimeOptions, descriptions, categoryName, displayNames, expirationCache, initParams, keywords, liferayConfiguration, multipartConfig, portletClassName, portletDependencies, portletName, preferences, preferencesValidator, resourceBundle, securityRoleRefs, shortTitles, supportedLocales, supportedPortletModes, supportedProcessingEvents, supportedPublicRenderParameters, supportedPublishingEvents, supportedWindowStates, titles);
    }

    private static Map<String, String> _toLocaleMap(List<Element> elements) {
        HashMap<String, String> localeMap = new HashMap<String, String>();
        for (Element element : elements) {
            String lang = element.attributeValue("lang");
            if (lang == null) {
                lang = _ENGLISH_EN;
            }
            localeMap.put(lang, GetterUtil.getString((String)element.getText()));
        }
        return localeMap;
    }
}

