/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.rest.internal.vulcan.batch.engine;

import com.liferay.batch.planner.rest.internal.vulcan.yaml.openapi.OpenAPIYAMLProvider;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.batch.engine.Field;
import com.liferay.portal.vulcan.util.OpenAPIUtil;
import com.liferay.portal.vulcan.yaml.openapi.OpenAPIYAML;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FieldProvider.class})
public class FieldProvider {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryOpenAPIResource _objectEntryOpenAPIResource;
    @Reference
    private OpenAPIYAMLProvider _openAPIYAMLProvider;

    public List<Field> filter(List<Field> fields, Field.AccessType ignoredAccessType) {
        return ListUtil.filter(fields, dtoEntityField -> {
            if (dtoEntityField.getAccessType() == ignoredAccessType) {
                return false;
            }
            String name = dtoEntityField.getName();
            return !name.equals("actions") && !name.startsWith("x-");
        });
    }

    public List<Field> getFields(long companyId, String objectDefinitionName, UriInfo uriInfo) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(companyId, objectDefinitionName);
        Map fields = this._objectEntryOpenAPIResource.getFields(objectDefinition, uriInfo);
        return new ArrayList<Field>(fields.values());
    }

    public List<Field> getFields(String internalClassName) throws Exception {
        OpenAPIYAML openAPIYAML = this._openAPIYAMLProvider.getOpenAPIYAML(internalClassName);
        Map dtoEntityFields = OpenAPIUtil.getDTOEntityFields((String)internalClassName.substring(internalClassName.lastIndexOf(".") + 1), (OpenAPIYAML)openAPIYAML);
        return new ArrayList<Field>(dtoEntityFields.values());
    }
}

