/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.rest.internal.resource.v1_0;

import com.liferay.batch.planner.model.BatchPlannerMapping;
import com.liferay.batch.planner.model.BatchPlannerPlan;
import com.liferay.batch.planner.model.BatchPlannerPolicy;
import com.liferay.batch.planner.rest.dto.v1_0.Mapping;
import com.liferay.batch.planner.rest.dto.v1_0.Plan;
import com.liferay.batch.planner.rest.dto.v1_0.Policy;
import com.liferay.batch.planner.rest.internal.resource.v1_0.BasePlanResourceImpl;
import com.liferay.batch.planner.rest.internal.vulcan.batch.engine.FieldProvider;
import com.liferay.batch.planner.rest.resource.v1_0.PlanResource;
import com.liferay.batch.planner.service.BatchPlannerMappingService;
import com.liferay.batch.planner.service.BatchPlannerPlanService;
import com.liferay.batch.planner.service.BatchPlannerPolicyService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.batch.engine.Field;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/plan.properties"}, scope=ServiceScope.PROTOTYPE, service={PlanResource.class})
public class PlanResourceImpl
extends BasePlanResourceImpl {
    @Reference
    private BatchPlannerMappingService _batchPlannerMappingService;
    @Reference
    private BatchPlannerPlanService _batchPlannerPlanService;
    @Reference
    private BatchPlannerPolicyService _batchPlannerPolicyService;
    @Reference
    private FieldProvider _fieldProvider;

    @Override
    public void deletePlan(Long id) throws Exception {
        this._batchPlannerPlanService.deleteBatchPlannerPlan(id.longValue());
    }

    @Override
    public Plan getPlan(Long id) throws Exception {
        return this._toPlan(this._batchPlannerPlanService.getBatchPlannerPlan(id.longValue()));
    }

    @Override
    public Page<Plan> getPlansPage(Pagination pagination) throws Exception {
        return Page.of(this.transform(this._batchPlannerPlanService.getBatchPlannerPlans(this.contextCompany.getCompanyId(), pagination.getStartPosition(), pagination.getEndPosition()), this::_toPlan), (Pagination)pagination, (long)this._batchPlannerPlanService.getBatchPlannerPlansCount(this.contextCompany.getCompanyId()));
    }

    @Override
    public Response getPlanTemplate(String internalClassName) throws Exception {
        return this._getResponse(internalClassName.substring(internalClassName.lastIndexOf(".") + 1), this._fieldProvider.getFields(internalClassName));
    }

    @Override
    public Plan patchPlan(Long id, Plan plan) throws Exception {
        Policy[] policies;
        BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanService.updateBatchPlannerPlan(id.longValue(), plan.getExternalType(), plan.getInternalClassName(), plan.getName());
        Mapping[] mappings = plan.getMappings();
        if (mappings != null) {
            for (Mapping mapping : plan.getMappings()) {
                this._batchPlannerMappingService.updateBatchPlannerMapping(mapping.getId().longValue(), mapping.getExternalFieldName(), mapping.getExternalFieldType(), mapping.getScript());
            }
        }
        if ((policies = plan.getPolicies()) != null) {
            for (Policy policy : plan.getPolicies()) {
                this._batchPlannerPolicyService.updateBatchPlannerPolicy(id.longValue(), policy.getName(), policy.getValue());
            }
        }
        return this._toPlan(batchPlannerPlan);
    }

    @Override
    public Plan postPlan(Plan plan) throws Exception {
        Policy[] policies;
        BatchPlannerPlan batchPlannerPlan = this._batchPlannerPlanService.addBatchPlannerPlan(plan.getExport().booleanValue(), plan.getExternalType(), plan.getExternalURL(), plan.getInternalClassName(), plan.getName(), 0, plan.getTaskItemDelegateName(), plan.getTemplate().booleanValue());
        Mapping[] mappings = plan.getMappings();
        if (mappings != null) {
            for (Mapping mapping : mappings) {
                this._batchPlannerMappingService.addBatchPlannerMapping(batchPlannerPlan.getBatchPlannerPlanId(), mapping.getExternalFieldName(), mapping.getExternalFieldType(), mapping.getInternalFieldName(), mapping.getInternalFieldType(), mapping.getScript());
            }
        }
        if ((policies = plan.getPolicies()) != null) {
            for (Policy policy : plan.getPolicies()) {
                this._batchPlannerPolicyService.addBatchPlannerPolicy(batchPlannerPlan.getBatchPlannerPlanId(), policy.getName(), policy.getValue());
            }
        }
        return this._toPlan(batchPlannerPlan);
    }

    private Response _getResponse(String dtoEntityName, List<Field> fields) {
        fields = this._fieldProvider.filter(fields, Field.AccessType.READ);
        Iterator<Field> iterator = fields.iterator();
        StringBundler headerSB = new StringBundler(fields.size() * 2);
        StringBundler lineSB = new StringBundler(fields.size() * 2);
        while (iterator.hasNext()) {
            Field field = iterator.next();
            String fieldName = field.getName();
            if (fieldName.endsWith("_i18n")) {
                fieldName = StringBundler.concat((String[])new String[]{fieldName, "_", this.contextAcceptLanguage.getPreferredLanguageId()});
            }
            headerSB.append(fieldName);
            lineSB.append(field.getType());
            if (!iterator.hasNext()) continue;
            headerSB.append(",");
            lineSB.append(",");
        }
        return Response.ok((Object)StringBundler.concat((String[])new String[]{headerSB.toString(), System.lineSeparator(), lineSB.toString()})).header("content-disposition", (Object)StringBundler.concat((String[])new String[]{"attachment; filename=", StringUtil.toLowerCase((String)dtoEntityName), "-", StringUtil.randomString(), ".csv"})).build();
    }

    private Mapping _toMapping(final BatchPlannerMapping batchPlannerMapping) {
        return new Mapping(){
            {
                this.externalFieldName = batchPlannerMapping.getExternalFieldName();
                this.externalFieldType = batchPlannerMapping.getExternalFieldType();
                this.id = batchPlannerMapping.getBatchPlannerMappingId();
                this.internalFieldName = batchPlannerMapping.getInternalFieldName();
                this.internalFieldType = batchPlannerMapping.getInternalFieldType();
                this.planId = batchPlannerMapping.getBatchPlannerPlanId();
                this.script = batchPlannerMapping.getScript();
            }
        };
    }

    private Plan _toPlan(final BatchPlannerPlan batchPlannerPlan) throws Exception {
        return new Plan(){
            {
                this.active = batchPlannerPlan.isActive();
                this.export = batchPlannerPlan.isExport();
                this.externalType = batchPlannerPlan.getExternalType();
                this.externalURL = batchPlannerPlan.getExternalURL();
                this.id = batchPlannerPlan.getBatchPlannerPlanId();
                this.internalClassName = batchPlannerPlan.getInternalClassName();
                this.mappings = (Mapping[])PlanResourceImpl.this.transformToArray(PlanResourceImpl.this._batchPlannerMappingService.getBatchPlannerMappings(batchPlannerPlan.getBatchPlannerPlanId()), batchPlannerMapping -> PlanResourceImpl.this._toMapping(batchPlannerMapping), Mapping.class);
                this.name = batchPlannerPlan.getName();
                this.policies = (Policy[])PlanResourceImpl.this.transformToArray(PlanResourceImpl.this._batchPlannerPolicyService.getBatchPlannerPolicies(batchPlannerPlan.getBatchPlannerPlanId()), batchPlannerPolicy -> PlanResourceImpl.this._toPolicy(batchPlannerPolicy), Policy.class);
                this.taskItemDelegateName = batchPlannerPlan.getTaskItemDelegateName();
                this.template = batchPlannerPlan.isTemplate();
            }
        };
    }

    private Policy _toPolicy(final BatchPlannerPolicy batchPlannerPolicy) {
        return new Policy(){
            {
                this.id = batchPlannerPolicy.getBatchPlannerPolicyId();
                this.name = batchPlannerPolicy.getName();
                this.planId = batchPlannerPolicy.getBatchPlannerPlanId();
                this.value = batchPlannerPolicy.getValue();
            }
        };
    }
}

