/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.planner.constants;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Map;

public class BatchPlannerPlanConstants {
    public static final String EXTERNAL_TYPE_CSV = "CSV";
    public static final String EXTERNAL_TYPE_JSON = "JSON";
    public static final String EXTERNAL_TYPE_JSONL = "JSONL";
    public static final String EXTERNAL_TYPE_JSONT = "JSONT";
    public static final String EXTERNAL_TYPE_TXT = "TXT";
    public static final String EXTERNAL_TYPE_XLS = "XLS";
    public static final String EXTERNAL_TYPE_XLSX = "XLSX";
    public static final String EXTERNAL_TYPE_XML = "XML";
    public static final String[] EXTERNAL_TYPES = new String[]{"CSV", "JSON", "JSONL", "JSONT", "TXT", "XLS", "XLSX", "XML"};
    public static final String LABEL_COMPLETED = "completed";
    public static final String LABEL_FAILED = "failed";
    public static final String LABEL_INACTIVE = "inactive";
    public static final String LABEL_PARTIALLY_COMPLETED = "partially-completed";
    public static final String LABEL_QUEUED = "queued";
    public static final String LABEL_RUNNING = "running";
    public static final int STATUS_COMPLETED = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_INACTIVE = 0;
    public static final int STATUS_PARTIALLY_COMPLETED = 5;
    public static final int STATUS_QUEUED = 1;
    public static final int STATUS_RUNNING = 2;
    private static final Map<String, String> _contentTypes = HashMapBuilder.put((Object)"CSV", (Object)"text/csv").put((Object)"JSON", (Object)"application/json").put((Object)"JSONL", (Object)"application/x-ndjson").put((Object)"JSONT", (Object)"application/json").put((Object)"TXT", (Object)"text/plain").put((Object)"XLS", (Object)"XLS").put((Object)"XLSX", (Object)"XLSX").put((Object)"XML", (Object)"text/xml").build();

    public static String getContentType(String externalType) {
        return _contentTypes.get(externalType);
    }

    public static int getStatus(BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus) {
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.COMPLETED) {
            return 3;
        }
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.FAILED) {
            return 4;
        }
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.INITIAL) {
            return 1;
        }
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.STARTED) {
            return 2;
        }
        return 0;
    }

    public static String getStatusCssClass(int status) {
        if (status == 3) {
            return "text-success";
        }
        if (status == 4) {
            return "text-danger";
        }
        if (status == 1 || status == 2) {
            return "text-info";
        }
        return "text-warning";
    }

    public static String getStatusLabel(int status) {
        if (status == 3) {
            return LABEL_COMPLETED;
        }
        if (status == 4) {
            return LABEL_FAILED;
        }
        if (status == 5) {
            return LABEL_PARTIALLY_COMPLETED;
        }
        if (status == 1) {
            return LABEL_QUEUED;
        }
        if (status == 2) {
            return LABEL_RUNNING;
        }
        return LABEL_INACTIVE;
    }
}

