/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.service.impl;

import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.service.base.BatchEngineExportTaskLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.batch.engine.model.BatchEngineExportTask"}, service={AopService.class})
public class BatchEngineExportTaskLocalServiceImpl
extends BatchEngineExportTaskLocalServiceBaseImpl {
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BatchEngineExportTask addBatchEngineExportTask(String externalReferenceCode, long companyId, long userId, String callbackURL, String className, String contentType, String executeStatus, List<String> fieldNamesList, Map<String, Serializable> parameters, String taskItemDelegateName) {
        BatchEngineExportTask batchEngineExportTask = this.batchEngineExportTaskPersistence.create(this.counterLocalService.increment(BatchEngineExportTask.class.getName()));
        batchEngineExportTask.setExternalReferenceCode(externalReferenceCode);
        batchEngineExportTask.setCompanyId(companyId);
        batchEngineExportTask.setUserId(userId);
        batchEngineExportTask.setCallbackURL(callbackURL);
        batchEngineExportTask.setClassName(className);
        batchEngineExportTask.setContent((Blob)new OutputBlob((InputStream)new UnsyncByteArrayInputStream(new byte[0]), 0L));
        batchEngineExportTask.setContentType(contentType);
        batchEngineExportTask.setExecuteStatus(executeStatus);
        batchEngineExportTask.setFieldNamesList(fieldNamesList);
        batchEngineExportTask.setParameters(parameters);
        batchEngineExportTask.setTaskItemDelegateName(taskItemDelegateName);
        return (BatchEngineExportTask)this.batchEngineExportTaskPersistence.update((BaseModel)batchEngineExportTask);
    }

    public List<BatchEngineExportTask> getBatchEngineExportTasks(long companyId, int start, int end) {
        return this.batchEngineExportTaskPersistence.findByCompanyId(companyId, start, end);
    }

    public List<BatchEngineExportTask> getBatchEngineExportTasks(long companyId, int start, int end, OrderByComparator<BatchEngineExportTask> orderByComparator) {
        return this.batchEngineExportTaskPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<BatchEngineExportTask> getBatchEngineExportTasks(String executeStatus) {
        return this.batchEngineExportTaskPersistence.findByExecuteStatus(executeStatus);
    }

    public int getBatchEngineExportTasksCount(long companyId) {
        return this.batchEngineExportTaskPersistence.countByCompanyId(companyId);
    }
}

