/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.FieldNameValueMapHandlerFactory;
import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVBatchEngineImportTaskItemReaderImpl
implements BatchEngineImportTaskItemReader {
    private final CSVParser _csvParser;
    private final String[] _fieldNames;
    private final Iterator<CSVRecord> _iterator;

    public CSVBatchEngineImportTaskItemReaderImpl(String delimiter, InputStream inputStream, Map<String, Serializable> parameters) throws IOException {
        this._csvParser = CSVParser.parse((Reader)new UnsyncBufferedReader((Reader)new InputStreamReader(inputStream)), (CSVFormat)this._getCSVFormat((String)((Object)parameters.getOrDefault("delimiter", (Serializable)((Object)delimiter))), parameters.getOrDefault("enclosingCharacter", null)));
        this._iterator = this._csvParser.iterator();
        this._fieldNames = this._getFieldNames(Boolean.valueOf((String)((Object)parameters.getOrDefault("containsHeaders", (Serializable)((Object)"true")))), this._iterator);
    }

    @Override
    public void close() throws IOException {
        this._csvParser.close();
    }

    @Override
    public Map<String, Object> read() throws Exception {
        if (!this._iterator.hasNext()) {
            return null;
        }
        HashMap<String, Object> fieldNameValueMap = new HashMap<String, Object>();
        CSVRecord csvRecord = this._iterator.next();
        List values = csvRecord.toList();
        for (int i = 0; i < values.size(); ++i) {
            String fieldName = this._fieldNames[i];
            if (fieldName == null) continue;
            FieldNameValueMapHandlerFactory.FieldNameValueMapHandler fieldNameValueMapHandler = FieldNameValueMapHandlerFactory.getFieldNameValueMapHandler(fieldName);
            fieldNameValueMapHandler.handle(fieldName, fieldNameValueMap, (String)values.get(i));
        }
        return fieldNameValueMap;
    }

    private CSVFormat _getCSVFormat(String delimiter, String enclosingCharacter) {
        CSVFormat.Builder builder = CSVFormat.Builder.create().setDelimiter(delimiter).setIgnoreEmptyLines(true);
        if (Validator.isNotNull((String)enclosingCharacter)) {
            builder.setQuote(enclosingCharacter.charAt(0));
        }
        return builder.build();
    }

    private String[] _getFieldNames(boolean containsHeaders, Iterator<CSVRecord> csvRecordIterator) {
        if (containsHeaders) {
            CSVRecord csvRecord = csvRecordIterator.next();
            List fieldNamesList = csvRecord.toList();
            return fieldNamesList.toArray(new String[0]);
        }
        String[] fieldNames = new String[100];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = String.valueOf(i);
        }
        return fieldNames;
    }
}

