/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.strategy.BatchEngineImportStrategy;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.odata.entity.EntityModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class BaseBatchEngineTaskItemDelegate<T>
implements BatchEngineTaskItemDelegate<T> {
    protected BatchEngineImportStrategy batchEngineImportStrategy;
    protected Company contextCompany;
    protected User contextUser;
    protected String languageId;

    @Override
    public void create(Collection<T> items, Map<String, Serializable> parameters) throws Exception {
        this.batchEngineImportStrategy.apply(items, item -> this.createItem(item, parameters));
    }

    public void createItem(T item, Map<String, Serializable> parameters) throws Exception {
    }

    @Override
    public void delete(Collection<T> items, Map<String, Serializable> parameters) throws Exception {
        for (T item : items) {
            this.deleteItem(item, parameters);
        }
    }

    public void deleteItem(T item, Map<String, Serializable> parameters) throws Exception {
    }

    @Override
    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return null;
    }

    @Override
    public void setBatchEngineImportStrategy(BatchEngineImportStrategy batchEngineImportStrategy) {
        this.batchEngineImportStrategy = batchEngineImportStrategy;
    }

    @Override
    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    @Override
    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    @Override
    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    @Override
    public void update(Collection<T> items, Map<String, Serializable> parameters) throws Exception {
        for (T item : items) {
            this.updateItem(item, parameters);
        }
    }

    public void updateItem(T item, Map<String, Serializable> parameters) throws Exception {
    }
}

