/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.batch.engine.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the BatchEngineImportTaskError service. Represents a row in the &quot;BatchEngineImportTaskError&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.batch.engine.model.impl.BatchEngineImportTaskErrorModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.batch.engine.model.impl.BatchEngineImportTaskErrorImpl</code>.
 * </p>
 *
 * @author Shuyang Zhou
 * @see BatchEngineImportTaskError
 * @generated
 */
@ProviderType
public interface BatchEngineImportTaskErrorModel
	extends BaseModel<BatchEngineImportTaskError>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a batch engine import task error model instance should use the {@link BatchEngineImportTaskError} interface instead.
	 */

	/**
	 * Returns the primary key of this batch engine import task error.
	 *
	 * @return the primary key of this batch engine import task error
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this batch engine import task error.
	 *
	 * @param primaryKey the primary key of this batch engine import task error
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this batch engine import task error.
	 *
	 * @return the mvcc version of this batch engine import task error
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this batch engine import task error.
	 *
	 * @param mvccVersion the mvcc version of this batch engine import task error
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the batch engine import task error ID of this batch engine import task error.
	 *
	 * @return the batch engine import task error ID of this batch engine import task error
	 */
	public long getBatchEngineImportTaskErrorId();

	/**
	 * Sets the batch engine import task error ID of this batch engine import task error.
	 *
	 * @param batchEngineImportTaskErrorId the batch engine import task error ID of this batch engine import task error
	 */
	public void setBatchEngineImportTaskErrorId(
		long batchEngineImportTaskErrorId);

	/**
	 * Returns the company ID of this batch engine import task error.
	 *
	 * @return the company ID of this batch engine import task error
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this batch engine import task error.
	 *
	 * @param companyId the company ID of this batch engine import task error
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this batch engine import task error.
	 *
	 * @return the user ID of this batch engine import task error
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this batch engine import task error.
	 *
	 * @param userId the user ID of this batch engine import task error
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this batch engine import task error.
	 *
	 * @return the user uuid of this batch engine import task error
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this batch engine import task error.
	 *
	 * @param userUuid the user uuid of this batch engine import task error
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this batch engine import task error.
	 *
	 * @return the create date of this batch engine import task error
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this batch engine import task error.
	 *
	 * @param createDate the create date of this batch engine import task error
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this batch engine import task error.
	 *
	 * @return the modified date of this batch engine import task error
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this batch engine import task error.
	 *
	 * @param modifiedDate the modified date of this batch engine import task error
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the batch engine import task ID of this batch engine import task error.
	 *
	 * @return the batch engine import task ID of this batch engine import task error
	 */
	public long getBatchEngineImportTaskId();

	/**
	 * Sets the batch engine import task ID of this batch engine import task error.
	 *
	 * @param batchEngineImportTaskId the batch engine import task ID of this batch engine import task error
	 */
	public void setBatchEngineImportTaskId(long batchEngineImportTaskId);

	/**
	 * Returns the item of this batch engine import task error.
	 *
	 * @return the item of this batch engine import task error
	 */
	@AutoEscape
	public String getItem();

	/**
	 * Sets the item of this batch engine import task error.
	 *
	 * @param item the item of this batch engine import task error
	 */
	public void setItem(String item);

	/**
	 * Returns the item index of this batch engine import task error.
	 *
	 * @return the item index of this batch engine import task error
	 */
	public int getItemIndex();

	/**
	 * Sets the item index of this batch engine import task error.
	 *
	 * @param itemIndex the item index of this batch engine import task error
	 */
	public void setItemIndex(int itemIndex);

	/**
	 * Returns the message of this batch engine import task error.
	 *
	 * @return the message of this batch engine import task error
	 */
	@AutoEscape
	public String getMessage();

	/**
	 * Sets the message of this batch engine import task error.
	 *
	 * @param message the message of this batch engine import task error
	 */
	public void setMessage(String message);

	@Override
	public BatchEngineImportTaskError cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}