/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.link.internal.exportimport.staged.model.repository;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.asset.kernel.model.adapter.StagedAssetLink"}, service={StagedAssetLinkStagedModelRepository.class, StagedModelRepository.class})
public class StagedAssetLinkStagedModelRepository
implements StagedModelRepository<StagedAssetLink> {
    private static final Log _log = LogFactoryUtil.getLog(StagedAssetLinkStagedModelRepository.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public StagedAssetLink addStagedModel(PortletDataContext portletDataContext, StagedAssetLink stagedAssetLink) throws PortalException {
        AssetEntry assetEntry1 = this.fetchAssetEntry(portletDataContext.getScopeGroupId(), stagedAssetLink.getEntry1Uuid());
        AssetEntry assetEntry2 = this.fetchAssetEntry(portletDataContext.getScopeGroupId(), stagedAssetLink.getEntry2Uuid());
        if (assetEntry1 == null || assetEntry2 == null) {
            return null;
        }
        AssetLink assetLink = this._assetLinkLocalService.addLink(portletDataContext.getUserId(stagedAssetLink.getUserUuid()), assetEntry1.getEntryId(), assetEntry2.getEntryId(), stagedAssetLink.getType(), stagedAssetLink.getWeight());
        return (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
    }

    public void deleteStagedModel(StagedAssetLink stagedAssetLink) throws PortalException {
        this._assetLinkLocalService.deleteLink((AssetLink)stagedAssetLink);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        StagedAssetLink stagedAssetLink = this.fetchExistingAssetLink(groupId, this.parseAssetEntry1Uuid(uuid), this.parseAssetEntry2Uuid(uuid));
        if (stagedAssetLink != null) {
            this.deleteStagedModel(stagedAssetLink);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this._assetLinkLocalService.deleteGroupLinks(portletDataContext.getScopeGroupId());
    }

    public StagedAssetLink fetchExistingAssetLink(long groupId, String assetEntry1Uuid, String assetEntry2Uuid) throws PortalException {
        AssetEntry assetEntry1 = this.fetchAssetEntry(groupId, assetEntry1Uuid);
        AssetEntry assetEntry2 = this.fetchAssetEntry(groupId, assetEntry2Uuid);
        if (assetEntry1 == null || assetEntry2 == null) {
            return null;
        }
        DynamicQuery dynamicQuery = this.getAssetLinkDynamicQuery(assetEntry1.getEntryId(), assetEntry2.getEntryId());
        List assetLinks = this._assetLinkLocalService.dynamicQuery(dynamicQuery);
        if (ListUtil.isNotEmpty((List)assetLinks)) {
            return (StagedAssetLink)ModelAdapterUtil.adapt(assetLinks.get(0), AssetLink.class, StagedAssetLink.class);
        }
        return null;
    }

    public StagedAssetLink fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return null;
    }

    public List<StagedAssetLink> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        DynamicQuery dynamicQuery = this.getAssetLinkDynamicQuery(companyId, 0L, this.parseAssetEntry1Uuid(uuid), this.parseAssetEntry2Uuid(uuid));
        dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"linkId"));
        List assetLinks = this._assetLinkLocalService.dynamicQuery(dynamicQuery);
        if (ListUtil.isNotEmpty((List)assetLinks)) {
            return ModelAdapterUtil.adapt((List)assetLinks, AssetLink.class, StagedAssetLink.class);
        }
        return Collections.emptyList();
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return new ExportActionableDynamicQuery();
    }

    public StagedAssetLink getStagedModel(long assetLinkId) throws PortalException {
        AssetLink assetLink = this._assetLinkLocalService.getAssetLink(assetLinkId);
        return (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
    }

    public StagedAssetLink saveStagedModel(StagedAssetLink stagedAssetLink) throws PortalException {
        AssetLink assetLink = this._assetLinkLocalService.updateAssetLink((AssetLink)stagedAssetLink);
        return (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
    }

    public StagedAssetLink updateStagedModel(PortletDataContext portletDataContext, StagedAssetLink stagedAssetLink) throws PortalException {
        long userId = portletDataContext.getUserId(stagedAssetLink.getUserUuid());
        AssetLink assetLink = this._assetLinkLocalService.updateLink(userId, stagedAssetLink.getEntryId1(), stagedAssetLink.getEntryId2(), stagedAssetLink.getType(), stagedAssetLink.getWeight());
        return (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
    }

    protected AssetEntry fetchAssetEntry(long groupId, String uuid) throws PortalException {
        DynamicQuery dynamicQuery = this._assetEntryLocalService.dynamicQuery();
        Property classUuidProperty = PropertyFactoryUtil.forName((String)"classUuid");
        dynamicQuery.add(classUuidProperty.eq((Object)uuid));
        List assetEntries = this._assetEntryLocalService.dynamicQuery(dynamicQuery);
        if (ListUtil.isEmpty((List)assetEntries)) {
            return null;
        }
        HashMap<Long, AssetEntry> assetEntryMap = new HashMap<Long, AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            assetEntryMap.put(assetEntry.getGroupId(), assetEntry);
        }
        if (assetEntryMap.containsKey(groupId)) {
            return (AssetEntry)assetEntryMap.get(groupId);
        }
        Group group = this._groupLocalService.getGroup(groupId);
        for (Group parentGroup = group.getParentGroup(); parentGroup != null; parentGroup = parentGroup.getParentGroup()) {
            AssetEntry assetEntry;
            if (!assetEntryMap.containsKey(parentGroup.getGroupId()) || !this.isAssetEntryApplicable(assetEntry = (AssetEntry)assetEntryMap.get(parentGroup.getGroupId()))) continue;
            return assetEntry;
        }
        Group companyGroup = this._groupLocalService.fetchCompanyGroup(group.getCompanyId());
        if (assetEntryMap.containsKey(companyGroup.getGroupId())) {
            return (AssetEntry)assetEntryMap.get(companyGroup.getGroupId());
        }
        Stream assetEntryStream = assetEntries.stream();
        List companyAssetEntries = assetEntryStream.filter(entry -> entry.getCompanyId() == group.getCompanyId()).collect(Collectors.toList());
        if (ListUtil.isEmpty(companyAssetEntries)) {
            return null;
        }
        for (AssetEntry assetEntry : companyAssetEntries) {
            try {
                if (!this.isAssetEntryApplicable(assetEntry)) continue;
                return assetEntry;
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return null;
    }

    protected DynamicQuery getAssetLinkDynamicQuery(long entryId1, long entryId2) {
        DynamicQuery dynamicQuery = this._assetLinkLocalService.dynamicQuery();
        Property entryId1IdProperty = PropertyFactoryUtil.forName((String)"entryId1");
        dynamicQuery.add(entryId1IdProperty.eq((Object)entryId1));
        Property entryId2IdProperty = PropertyFactoryUtil.forName((String)"entryId2");
        dynamicQuery.add(entryId2IdProperty.eq((Object)entryId2));
        return dynamicQuery;
    }

    protected DynamicQuery getAssetLinkDynamicQuery(long companyId, long groupId, String assetEntry1Uuid, String assetEntry2Uuid) {
        Projection entryIdProjection = ProjectionFactoryUtil.property((String)"entryId");
        DynamicQuery assetEntry1DynamicQuery = this._assetEntryLocalService.dynamicQuery();
        assetEntry1DynamicQuery.setProjection(entryIdProjection);
        Property classUuidProperty = PropertyFactoryUtil.forName((String)"classUuid");
        assetEntry1DynamicQuery.add(classUuidProperty.eq((Object)assetEntry1Uuid));
        DynamicQuery assetEntry2DynamicQuery = this._assetEntryLocalService.dynamicQuery();
        assetEntry2DynamicQuery.setProjection(entryIdProjection);
        assetEntry2DynamicQuery.add(classUuidProperty.eq((Object)assetEntry2Uuid));
        DynamicQuery dynamicQuery = this._assetLinkLocalService.dynamicQuery();
        Property entryId1IdProperty = PropertyFactoryUtil.forName((String)"entryId1");
        dynamicQuery.add(entryId1IdProperty.eq(assetEntry1DynamicQuery));
        Property entryId2IdProperty = PropertyFactoryUtil.forName((String)"entryId2");
        dynamicQuery.add(entryId2IdProperty.eq(assetEntry2DynamicQuery));
        if (companyId > 0L) {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            Criterion companyIdCriterion = companyIdProperty.eq((Object)companyId);
            assetEntry1DynamicQuery.add(companyIdCriterion);
            assetEntry2DynamicQuery.add(companyIdCriterion);
            dynamicQuery.add(companyIdCriterion);
        }
        if (groupId > 0L) {
            Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
            Criterion groupIdCriterion = groupIdProperty.eq((Object)groupId);
            assetEntry1DynamicQuery.add(groupIdCriterion);
            assetEntry2DynamicQuery.add(groupIdCriterion);
        }
        return dynamicQuery;
    }

    protected boolean isAssetEntryApplicable(AssetEntry assetEntry) throws PortalException {
        StagedGroupedModel stagedGroupedModel;
        Group group;
        TrashedModel trashedModel;
        AssetRenderer assetRenderer = null;
        StagedModel stagedModel = null;
        try {
            assetRenderer = assetEntry.getAssetRenderer();
            stagedModel = (StagedModel)assetRenderer.getAssetObject();
        }
        catch (Exception e) {
            return false;
        }
        if (stagedModel instanceof TrashedModel && (trashedModel = (TrashedModel)stagedModel).isInTrash()) {
            return false;
        }
        return !(stagedModel instanceof StagedGroupedModel) || !(group = this._groupLocalService.getGroup((stagedGroupedModel = (StagedGroupedModel)stagedModel).getGroupId())).isStagingGroup();
    }

    protected String parseAssetEntry1Uuid(String uuid) {
        return uuid.substring(0, uuid.indexOf("#"));
    }

    protected String parseAssetEntry2Uuid(String uuid) {
        return uuid.substring(uuid.indexOf("#") + 1);
    }
}

