/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.internal.request.attributes.contributor;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.util.LinkedAssetEntryIdsUtil;
import com.liferay.info.display.request.attributes.contributor.InfoDisplayRequestAttributesContributor;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemDetailsProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoDisplayRequestAttributesContributor.class})
public class AssetInfoDisplayRequestAttributesContributor
implements InfoDisplayRequestAttributesContributor {
    private static final Log _log = LogFactoryUtil.getLog(AssetInfoDisplayRequestAttributesContributor.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutDisplayPageProviderRegistry _layoutDisplayPageProviderRegistry;

    public void addAttributes(HttpServletRequest httpServletRequest) {
        Object layoutAssetEntry = httpServletRequest.getAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY");
        if (!(layoutAssetEntry instanceof AssetEntry)) {
            return;
        }
        AssetEntry assetEntry = (AssetEntry)layoutAssetEntry;
        if (assetEntry != null) {
            return;
        }
        long assetEntryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"assetEntryId");
        assetEntry = this._assetEntryLocalService.fetchEntry(assetEntryId);
        if (assetEntry == null) {
            return;
        }
        LayoutDisplayPageProvider layoutDisplayPageProvider = this._layoutDisplayPageProviderRegistry.getLayoutDisplayPageProviderByClassName(assetEntry.getClassName());
        httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_PROVIDER", (Object)layoutDisplayPageProvider);
        try {
            InfoItemObjectProvider infoItemObjectProvider;
            LayoutDisplayPageObjectProvider layoutDisplayPageObjectProvider = layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(new InfoItemReference(assetEntry.getClassName(), assetEntry.getClassPK()));
            if (layoutDisplayPageObjectProvider != null) {
                httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER", (Object)layoutDisplayPageObjectProvider);
            }
            if ((infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, assetEntry.getClassName())) != null) {
                Object infoItem = infoItemObjectProvider.getInfoItem(assetEntry.getClassPK());
                httpServletRequest.setAttribute("INFO_ITEM", infoItem);
                InfoItemDetailsProvider infoItemDetailsProvider = (InfoItemDetailsProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemDetailsProvider.class, assetEntry.getClassName());
                httpServletRequest.setAttribute("INFO_ITEM_DETAILS", (Object)infoItemDetailsProvider.getInfoItemDetails(infoItem));
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get info display object provider", (Throwable)exception);
        }
        httpServletRequest.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)assetEntry);
        LinkedAssetEntryIdsUtil.addLinkedAssetEntryId((HttpServletRequest)httpServletRequest, (long)assetEntry.getEntryId());
    }
}

