/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.internal.request.attributes.contributor;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.info.display.request.attributes.contributor.InfoDisplayRequestAttributesContributor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoDisplayRequestAttributesContributor.class})
public class AssetInfoDisplayRequestAttributesContributor
implements InfoDisplayRequestAttributesContributor {
    private static final Log _log = LogFactoryUtil.getLog(AssetInfoDisplayRequestAttributesContributor.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private InfoDisplayContributorTracker _infoDisplayContributorTracker;

    public void addAttributes(HttpServletRequest httpServletRequest) {
        AssetEntry assetEntry = (AssetEntry)httpServletRequest.getAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY");
        if (assetEntry != null) {
            return;
        }
        long assetEntryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"assetEntryId");
        assetEntry = this._assetEntryLocalService.fetchEntry(assetEntryId);
        if (assetEntry == null) {
            return;
        }
        InfoDisplayContributor infoDisplayContributor = this._infoDisplayContributorTracker.getInfoDisplayContributor(assetEntry.getClassName());
        httpServletRequest.setAttribute("INFO_DISPLAY_CONTRIBUTOR", (Object)infoDisplayContributor);
        try {
            InfoDisplayObjectProvider infoDisplayObjectProvider = infoDisplayContributor.getInfoDisplayObjectProvider(assetEntry.getClassPK());
            if (infoDisplayObjectProvider != null) {
                httpServletRequest.setAttribute("INFO_DISPLAY_OBJECT_PROVIDER", (Object)infoDisplayObjectProvider);
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get info display object provider", (Throwable)e);
        }
        httpServletRequest.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)assetEntry);
    }
}

