/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.internal.url.provider;

import com.liferay.asset.info.display.url.provider.AssetInfoEditURLProvider;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={AssetInfoEditURLProvider.class})
public class AssetInfoEditURLProviderImpl
implements AssetInfoEditURLProvider {
    public String getURL(String className, long classPK, HttpServletRequest httpServletRequest) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null) {
            return "";
        }
        try {
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
            if (assetRenderer == null) {
                return "";
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!assetRenderer.hasEditPermission(themeDisplay.getPermissionChecker())) {
                return "";
            }
            PortletURL editAssetEntryURL = assetRenderer.getURLEdit(httpServletRequest, LiferayWindowState.NORMAL, themeDisplay.getURLCurrent());
            if (editAssetEntryURL == null) {
                return "";
            }
            editAssetEntryURL.setParameter("portletResource", assetRendererFactory.getPortletId());
            return editAssetEntryURL.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

