/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.asset.entry.rel.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

/**
 * The base model interface for the AssetEntryAssetCategoryRel service. Represents a row in the &quot;AssetEntryAssetCategoryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.asset.entry.rel.model.impl.AssetEntryAssetCategoryRelModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.asset.entry.rel.model.impl.AssetEntryAssetCategoryRelImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AssetEntryAssetCategoryRel
 * @see com.liferay.asset.entry.rel.model.impl.AssetEntryAssetCategoryRelImpl
 * @see com.liferay.asset.entry.rel.model.impl.AssetEntryAssetCategoryRelModelImpl
 * @generated
 */
@ProviderType
public interface AssetEntryAssetCategoryRelModel extends BaseModel<AssetEntryAssetCategoryRel> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a asset entry asset category rel model instance should use the {@link AssetEntryAssetCategoryRel} interface instead.
	 */

	/**
	 * Returns the primary key of this asset entry asset category rel.
	 *
	 * @return the primary key of this asset entry asset category rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this asset entry asset category rel.
	 *
	 * @param primaryKey the primary key of this asset entry asset category rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the asset entry asset category rel ID of this asset entry asset category rel.
	 *
	 * @return the asset entry asset category rel ID of this asset entry asset category rel
	 */
	public long getAssetEntryAssetCategoryRelId();

	/**
	 * Sets the asset entry asset category rel ID of this asset entry asset category rel.
	 *
	 * @param assetEntryAssetCategoryRelId the asset entry asset category rel ID of this asset entry asset category rel
	 */
	public void setAssetEntryAssetCategoryRelId(
		long assetEntryAssetCategoryRelId);

	/**
	 * Returns the asset entry ID of this asset entry asset category rel.
	 *
	 * @return the asset entry ID of this asset entry asset category rel
	 */
	public long getAssetEntryId();

	/**
	 * Sets the asset entry ID of this asset entry asset category rel.
	 *
	 * @param assetEntryId the asset entry ID of this asset entry asset category rel
	 */
	public void setAssetEntryId(long assetEntryId);

	/**
	 * Returns the asset category ID of this asset entry asset category rel.
	 *
	 * @return the asset category ID of this asset entry asset category rel
	 */
	public long getAssetCategoryId();

	/**
	 * Sets the asset category ID of this asset entry asset category rel.
	 *
	 * @param assetCategoryId the asset category ID of this asset entry asset category rel
	 */
	public void setAssetCategoryId(long assetCategoryId);

	/**
	 * Returns the priority of this asset entry asset category rel.
	 *
	 * @return the priority of this asset entry asset category rel
	 */
	public int getPriority();

	/**
	 * Sets the priority of this asset entry asset category rel.
	 *
	 * @param priority the priority of this asset entry asset category rel
	 */
	public void setPriority(int priority);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(AssetEntryAssetCategoryRel assetEntryAssetCategoryRel);

	@Override
	public int hashCode();

	@Override
	public CacheModel<AssetEntryAssetCategoryRel> toCacheModel();

	@Override
	public AssetEntryAssetCategoryRel toEscapedModel();

	@Override
	public AssetEntryAssetCategoryRel toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}