/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.entry.query.processor.custom.user.attributes.internal;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.util.AssetEntryQueryProcessor;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet"}, service={AssetEntryQueryProcessor.class})
public class CustomUserAttributesAssetEntryQueryProcessor
implements AssetEntryQueryProcessor {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public void processAssetEntryQuery(User user, PortletPreferences preferences, AssetEntryQuery assetEntryQuery) throws Exception {
        String customUserAttributes = GetterUtil.getString((String)preferences.getValue("customUserAttributes", ""));
        this._addUserAttributes(user, StringUtil.split((String)customUserAttributes), assetEntryQuery);
    }

    private void _addUserAttributes(User user, String[] customUserAttributeNames, AssetEntryQuery assetEntryQuery) {
        if (user == null || customUserAttributeNames.length == 0) {
            return;
        }
        Group companyGroup = this._groupLocalService.fetchCompanyGroup(user.getCompanyId());
        long[] allCategoryIds = assetEntryQuery.getAllCategoryIds();
        PrimitiveLongList allCategoryIdsList = new PrimitiveLongList(allCategoryIds.length + customUserAttributeNames.length);
        allCategoryIdsList.addAll(allCategoryIds);
        for (String customUserAttributeName : customUserAttributeNames) {
            ExpandoBridge userCustomAttributes = user.getExpandoBridge();
            Serializable userCustomFieldValue = userCustomAttributes.getAttribute(customUserAttributeName);
            if (userCustomFieldValue == null) continue;
            String userCustomFieldValueString = userCustomFieldValue.toString();
            List assetCategories = this._assetCategoryLocalService.search(companyGroup.getGroupId(), userCustomFieldValueString, new String[0], -1, -1);
            for (AssetCategory assetCategory : assetCategories) {
                allCategoryIdsList.add(assetCategory.getCategoryId());
            }
        }
        assetEntryQuery.setAllCategoryIds(allCategoryIdsList.getArray());
    }
}

