/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.service.impl;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.base.AssetDisplayPageEntryLocalServiceBaseImpl;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Portal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.asset.display.page.model.AssetDisplayPageEntry"}, service={AopService.class})
public class AssetDisplayPageEntryLocalServiceImpl
extends AssetDisplayPageEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetDisplayPageEntryLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Portal _portal;

    public AssetDisplayPageEntry addAssetDisplayPageEntry(long userId, long groupId, long classNameId, long classPK, long layoutPageTemplateEntryId, int type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long assetDisplayPageEntryId = this.counterLocalService.increment();
        AssetDisplayPageEntry assetDisplayPageEntry = this.assetDisplayPageEntryPersistence.create(assetDisplayPageEntryId);
        assetDisplayPageEntry.setUuid(serviceContext.getUuid());
        assetDisplayPageEntry.setGroupId(groupId);
        assetDisplayPageEntry.setCompanyId(user.getCompanyId());
        assetDisplayPageEntry.setUserId(user.getUserId());
        assetDisplayPageEntry.setUserName(user.getFullName());
        assetDisplayPageEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        assetDisplayPageEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        assetDisplayPageEntry.setClassNameId(classNameId);
        assetDisplayPageEntry.setClassPK(classPK);
        assetDisplayPageEntry.setLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
        assetDisplayPageEntry.setType(type);
        long plid = this._getPlid(groupId, classNameId, classPK, layoutPageTemplateEntryId);
        assetDisplayPageEntry.setPlid(plid);
        this.assetDisplayPageEntryPersistence.update((BaseModel)assetDisplayPageEntry);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(assetDisplayPageEntryId);
        if (layoutPageTemplateEntry != null) {
            layoutPageTemplateEntry.setModifiedDate(new Date());
            this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        }
        return assetDisplayPageEntry;
    }

    public AssetDisplayPageEntry addAssetDisplayPageEntry(long userId, long groupId, long classNameId, long classPK, long layoutPageTemplateEntryId, ServiceContext serviceContext) throws PortalException {
        return this.addAssetDisplayPageEntry(userId, groupId, classNameId, classPK, layoutPageTemplateEntryId, 1, serviceContext);
    }

    @SystemEvent(type=1)
    public void deleteAssetDisplayPageEntry(long groupId, long classNameId, long classPK) throws PortalException {
        this.assetDisplayPageEntryPersistence.removeByG_C_C(groupId, classNameId, classPK);
    }

    public AssetDisplayPageEntry fetchAssetDisplayPageEntry(long groupId, long classNameId, long classPK) {
        return this.assetDisplayPageEntryPersistence.fetchByG_C_C(groupId, classNameId, classPK);
    }

    public List<AssetDisplayPageEntry> getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(long layoutPageTemplateEntryId) {
        return this.assetDisplayPageEntryPersistence.findByLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
    }

    public int getAssetDisplayPageEntriesCountByLayoutPageTemplateEntryId(long layoutPageTemplateEntryId) {
        return this.assetDisplayPageEntryPersistence.countByLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
    }

    public AssetDisplayPageEntry updateAssetDisplayPageEntry(long assetDisplayPageEntryId, long layoutPageTemplateEntryId, int type) throws PortalException {
        AssetDisplayPageEntry assetDisplayPageEntry = this.assetDisplayPageEntryPersistence.findByPrimaryKey(assetDisplayPageEntryId);
        assetDisplayPageEntry.setModifiedDate(new Date());
        assetDisplayPageEntry.setLayoutPageTemplateEntryId(layoutPageTemplateEntryId);
        assetDisplayPageEntry.setType(type);
        long plid = this._getPlid(assetDisplayPageEntry.getGroupId(), assetDisplayPageEntry.getClassNameId(), assetDisplayPageEntry.getClassPK(), layoutPageTemplateEntryId);
        assetDisplayPageEntry.setPlid(plid);
        this.assetDisplayPageEntryPersistence.update((BaseModel)assetDisplayPageEntry);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(assetDisplayPageEntryId);
        if (layoutPageTemplateEntry != null) {
            layoutPageTemplateEntry.setModifiedDate(new Date());
            this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        }
        return assetDisplayPageEntry;
    }

    private long _getPlid(long groupId, long classNameId, long classPK, long layoutPageTemplateEntryId) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameId);
        AssetEntry assetEntry = null;
        if (assetRendererFactory != null) {
            try {
                assetEntry = assetRendererFactory.getAssetEntry(this._portal.getClassName(classNameId), classPK);
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)pe, (Throwable)pe);
                }
            }
        } else {
            assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, classPK);
        }
        if (assetEntry == null) {
            return 0L;
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = Optional.ofNullable(this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId)).orElse(this._layoutPageTemplateEntryLocalService.fetchDefaultLayoutPageTemplateEntry(groupId, classNameId, assetEntry.getClassTypeId()));
        if (layoutPageTemplateEntry != null) {
            return layoutPageTemplateEntry.getPlid();
        }
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(assetEntry.getLayoutUuid(), assetEntry.getGroupId(), false);
        if (layout != null) {
            return layout.getPlid();
        }
        layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(assetEntry.getLayoutUuid(), assetEntry.getGroupId(), true);
        if (layout != null) {
            return layout.getPlid();
        }
        return 0L;
    }
}

