/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.portlet;

import com.liferay.asset.display.page.configuration.AssetDisplayPageConfiguration;
import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.util.AssetHelper;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.info.display.url.provider.InfoEditURLProviderTracker;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemDetailsProvider;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderTracker;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAssetDisplayPageFriendlyURLResolver
implements FriendlyURLResolver {
    @Reference
    protected AssetDisplayPageEntryLocalService assetDisplayPageEntryLocalService;
    @Reference
    protected AssetEntryService assetEntryLocalService;
    @Reference
    protected AssetHelper assetHelper;
    @Reference
    protected InfoDisplayContributorTracker infoDisplayContributorTracker;
    @Reference
    protected InfoEditURLProviderTracker infoEditURLProviderTracker;
    @Reference
    protected InfoItemServiceTracker infoItemServiceTracker;
    @Reference
    protected LayoutDisplayPageProviderTracker layoutDisplayPageProviderTracker;
    @Reference
    protected LayoutLocalService layoutLocalService;
    @Reference
    protected LayoutPageTemplateEntryService layoutPageTemplateEntryService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(BaseAssetDisplayPageFriendlyURLResolver.class);

    public String getActualURL(long companyId, long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
        LayoutDisplayPageProvider<?> layoutDisplayPageProvider = this._getLayoutDisplayPageProvider(friendlyURL);
        LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider = this._getLayoutDisplayPageObjectProvider(layoutDisplayPageProvider, groupId, friendlyURL);
        Object infoItem = this._getInfoItem(friendlyURL, layoutDisplayPageObjectProvider);
        httpServletRequest.setAttribute("INFO_ITEM", infoItem);
        String infoItemClassName = this.portal.getClassName(layoutDisplayPageObjectProvider.getClassNameId());
        InfoItemDetailsProvider infoItemDetailsProvider = (InfoItemDetailsProvider)this.infoItemServiceTracker.getFirstInfoItemService(InfoItemDetailsProvider.class, infoItemClassName);
        httpServletRequest.setAttribute("INFO_ITEM_DETAILS", (Object)infoItemDetailsProvider.getInfoItemDetails(infoItem));
        httpServletRequest.setAttribute("INFO_FIELD_VALUES_PROVIDER", this.infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, infoItemClassName));
        httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER", layoutDisplayPageObjectProvider);
        httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_PROVIDER", layoutDisplayPageProvider);
        httpServletRequest.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)this._getAssetEntry(layoutDisplayPageObjectProvider));
        Locale locale = this.portal.getLocale(httpServletRequest);
        Layout layout = this._getLayoutDisplayPageObjectProviderLayout(layoutDisplayPageObjectProvider);
        this.portal.setPageDescription(HtmlUtil.unescape((String)HtmlUtil.stripHtml((String)this._getMappedField(layoutDisplayPageObjectProvider, locale, layout.getTypeSettingsProperty("mapped-description"), arg_0 -> layoutDisplayPageObjectProvider.getDescription(arg_0)))), httpServletRequest);
        this.portal.setPageKeywords(layoutDisplayPageObjectProvider.getKeywords(locale), httpServletRequest);
        this.portal.setPageTitle(this._getMappedField(layoutDisplayPageObjectProvider, locale, layout.getTypeSettingsProperty("mapped-title"), arg_0 -> layoutDisplayPageObjectProvider.getTitle(arg_0)), httpServletRequest);
        return this.portal.getLayoutActualURL(layout, mainPath);
    }

    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String urlTitle;
        LayoutDisplayPageProvider<?> layoutDisplayPageProvider = this._getLayoutDisplayPageProvider(friendlyURL);
        LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider = this._getLayoutDisplayPageObjectProvider(layoutDisplayPageProvider, groupId, friendlyURL);
        if (layoutDisplayPageObjectProvider == null) {
            throw new PortalException();
        }
        Layout layout = this._getLayoutDisplayPageObjectProviderLayout(layoutDisplayPageObjectProvider);
        HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
        HttpSession httpSession = httpServletRequest.getSession();
        Locale locale = (Locale)httpSession.getAttribute("LOCALE");
        if (locale != null && Validator.isNotNull((String)(urlTitle = layoutDisplayPageObjectProvider.getURLTitle(locale)))) {
            friendlyURL = this.getURLSeparator() + urlTitle;
        }
        return new LayoutFriendlyURLComposite(layout, friendlyURL);
    }

    private AssetEntry _getAssetEntry(LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider) {
        AssetRendererFactory assetRendererFactory;
        long classNameId = layoutDisplayPageObjectProvider.getClassNameId();
        if (classNameId == this.portal.getClassNameId(FileEntry.class)) {
            classNameId = this.portal.getClassNameId(DLFileEntry.class);
        }
        if ((assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.portal.getClassName(classNameId))) == null) {
            return null;
        }
        long classPK = layoutDisplayPageObjectProvider.getClassPK();
        try {
            AssetEntry assetEntry = assetRendererFactory.getAssetEntry(this.portal.getClassName(classNameId), classPK);
            AssetDisplayPageConfiguration assetDisplayPageConfiguration = (AssetDisplayPageConfiguration)ConfigurationProviderUtil.getSystemConfiguration(AssetDisplayPageConfiguration.class);
            if (assetEntry != null && assetDisplayPageConfiguration.enableViewCountIncrement()) {
                this.assetEntryLocalService.incrementViewCounter(assetEntry);
            }
            return assetEntry;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return null;
        }
    }

    private Object _getInfoItem(String friendlyURL, LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider) throws NoSuchInfoItemException {
        long classPK = this._getVersionClassPK(friendlyURL);
        if (classPK <= 0L) {
            return layoutDisplayPageObjectProvider.getDisplayObject();
        }
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this.infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, this.portal.getClassName(layoutDisplayPageObjectProvider.getClassNameId()));
        ClassPKInfoItemIdentifier infoItemIdentifier = new ClassPKInfoItemIdentifier(layoutDisplayPageObjectProvider.getClassPK());
        infoItemIdentifier.setVersion("VERSION_LATEST");
        return infoItemObjectProvider.getInfoItem((InfoItemIdentifier)infoItemIdentifier);
    }

    private LayoutDisplayPageObjectProvider<?> _getLayoutDisplayPageObjectProvider(LayoutDisplayPageProvider<?> layoutDisplayPageProvider, long groupId, String friendlyURL) {
        return layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(groupId, this._getUrlTitle(friendlyURL));
    }

    private Layout _getLayoutDisplayPageObjectProviderLayout(LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider) {
        AssetDisplayPageEntry assetDisplayPageEntry = this.assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(layoutDisplayPageObjectProvider.getGroupId(), layoutDisplayPageObjectProvider.getClassNameId(), layoutDisplayPageObjectProvider.getClassPK());
        if (assetDisplayPageEntry == null) {
            return null;
        }
        if (assetDisplayPageEntry.getType() != 1) {
            return this.layoutLocalService.fetchLayout(assetDisplayPageEntry.getPlid());
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryService.fetchDefaultLayoutPageTemplateEntry(layoutDisplayPageObjectProvider.getGroupId(), layoutDisplayPageObjectProvider.getClassNameId(), layoutDisplayPageObjectProvider.getClassTypeId());
        if (layoutPageTemplateEntry != null) {
            return this.layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        }
        return null;
    }

    private LayoutDisplayPageProvider<?> _getLayoutDisplayPageProvider(String friendlyURL) throws PortalException {
        String urlSeparator = this._getURLSeparator(friendlyURL);
        LayoutDisplayPageProvider layoutDisplayPageProvider = this.layoutDisplayPageProviderTracker.getLayoutDisplayPageProviderByURLSeparator(urlSeparator);
        if (layoutDisplayPageProvider == null) {
            throw new PortalException("Info display contributor is not available for " + urlSeparator);
        }
        return layoutDisplayPageProvider;
    }

    private String _getMappedField(LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider, Locale locale, String mappedFieldName, Function<Locale, String> defaultValueFunction) {
        InfoItemFieldValuesProvider infoItemFieldValuesProvider;
        InfoFieldValue infoFieldValue;
        if (layoutDisplayPageObjectProvider != null && (infoFieldValue = (infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this.infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, this.portal.getClassName(layoutDisplayPageObjectProvider.getClassNameId()))).getInfoItemFieldValue(layoutDisplayPageObjectProvider.getDisplayObject(), mappedFieldName)) != null) {
            return String.valueOf(infoFieldValue.getValue(locale));
        }
        return defaultValueFunction.apply(locale);
    }

    private String _getURLSeparator(String friendlyURL) {
        List paths = StringUtil.split((String)friendlyURL, (char)'/');
        return '/' + (String)paths.get(0) + '/';
    }

    private String _getUrlTitle(String friendlyURL) {
        String urlSeparator = this._getURLSeparator(friendlyURL);
        String urlTitle = friendlyURL.substring(urlSeparator.length());
        long versionClassPK = this._getVersionClassPK(friendlyURL);
        if (versionClassPK > 0L) {
            String versionClassPKValue = String.valueOf(versionClassPK);
            urlTitle = friendlyURL.substring(urlSeparator.length(), friendlyURL.length() - versionClassPKValue.length() - 1);
        }
        return urlTitle;
    }

    private long _getVersionClassPK(String friendlyURL) {
        List paths = StringUtil.split((String)friendlyURL, (char)'/');
        if (paths.size() < 3) {
            return 0L;
        }
        return GetterUtil.getLong((String)((String)paths.get(paths.size() - 1)));
    }
}

