/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.portlet;

import com.liferay.asset.display.page.configuration.AssetDisplayPageConfiguration;
import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.util.AssetHelper;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.info.display.url.provider.InfoEditURLProvider;
import com.liferay.info.display.url.provider.InfoEditURLProviderTracker;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAssetDisplayPageFriendlyURLResolver
implements FriendlyURLResolver {
    @Reference
    protected AssetDisplayPageEntryLocalService assetDisplayPageEntryLocalService;
    @Reference
    protected AssetEntryService assetEntryLocalService;
    @Reference
    protected AssetHelper assetHelper;
    @Reference
    protected Http http;
    @Reference
    protected InfoDisplayContributorTracker infoDisplayContributorTracker;
    @Reference
    protected InfoEditURLProviderTracker infoEditURLProviderTracker;
    @Reference
    protected LayoutLocalService layoutLocalService;
    @Reference
    protected LayoutPageTemplateEntryService layoutPageTemplateEntryService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(BaseAssetDisplayPageFriendlyURLResolver.class);

    public String getActualURL(long companyId, long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
        InfoDisplayContributor infoDisplayContributor = this._getInfoDisplayContributor(friendlyURL);
        InfoDisplayObjectProvider infoDisplayObjectProvider = this._getInfoDisplayObjectProvider(infoDisplayContributor, groupId, friendlyURL, params);
        if (infoDisplayObjectProvider != null) {
            httpServletRequest.setAttribute("INFO_DISPLAY_OBJECT_PROVIDER", (Object)infoDisplayObjectProvider);
            InfoEditURLProvider infoEditURLProvider = this.infoEditURLProviderTracker.getInfoEditURLProvider(this.portal.getClassName(infoDisplayObjectProvider.getClassNameId()));
            httpServletRequest.setAttribute("INFO_EDIT_URL_PROVIDER", (Object)infoEditURLProvider);
        }
        httpServletRequest.setAttribute("INFO_DISPLAY_CONTRIBUTOR", (Object)infoDisplayContributor);
        httpServletRequest.setAttribute("VERSION_CLASS_PK", (Object)this._getVersionClassPK(params));
        Locale locale = this.portal.getLocale(httpServletRequest);
        this.portal.setPageDescription(HtmlUtil.unescape((String)HtmlUtil.stripHtml((String)infoDisplayObjectProvider.getDescription(locale))), httpServletRequest);
        this.portal.setPageKeywords(infoDisplayObjectProvider.getKeywords(locale), httpServletRequest);
        this.portal.setPageTitle(infoDisplayObjectProvider.getTitle(locale), httpServletRequest);
        httpServletRequest.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)this._getAssetEntry(infoDisplayObjectProvider));
        Layout layout = this._getInfoDisplayObjectProviderLayout(infoDisplayObjectProvider);
        return this.portal.getLayoutActualURL(layout, mainPath);
    }

    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String urlTitle;
        InfoDisplayObjectProvider infoDisplayObjectProvider = this._getInfoDisplayObjectProvider(this._getInfoDisplayContributor(friendlyURL), groupId, friendlyURL, params);
        if (infoDisplayObjectProvider == null) {
            throw new PortalException();
        }
        Layout layout = this._getInfoDisplayObjectProviderLayout(infoDisplayObjectProvider);
        HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
        HttpSession httpSession = httpServletRequest.getSession();
        Locale locale = (Locale)httpSession.getAttribute("LOCALE");
        if (locale != null && Validator.isNotNull((String)(urlTitle = infoDisplayObjectProvider.getURLTitle(locale)))) {
            friendlyURL = this.getURLSeparator() + urlTitle;
        }
        return new LayoutFriendlyURLComposite(layout, friendlyURL);
    }

    private AssetEntry _getAssetEntry(InfoDisplayObjectProvider infoDisplayObjectProvider) {
        String classNameId = PortalUtil.getClassName((long)infoDisplayObjectProvider.getClassNameId());
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)classNameId);
        if (assetRendererFactory == null) {
            return null;
        }
        long classPK = infoDisplayObjectProvider.getClassPK();
        try {
            AssetEntry assetEntry = assetRendererFactory.getAssetEntry(classNameId, classPK);
            AssetDisplayPageConfiguration assetDisplayPageConfiguration = (AssetDisplayPageConfiguration)ConfigurationProviderUtil.getSystemConfiguration(AssetDisplayPageConfiguration.class);
            if (assetEntry != null && assetDisplayPageConfiguration.enableViewCountIncrement()) {
                this.assetEntryLocalService.incrementViewCounter(assetEntry);
            }
            return assetEntry;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return null;
        }
    }

    private InfoDisplayContributor _getInfoDisplayContributor(String friendlyURL) throws PortalException {
        String infoURLSeparator = this._getInfoURLSeparator(friendlyURL);
        InfoDisplayContributor infoDisplayContributor = this.infoDisplayContributorTracker.getInfoDisplayContributorByURLSeparator(infoURLSeparator);
        if (infoDisplayContributor == null) {
            throw new PortalException("Info display contributor is not available for " + infoURLSeparator);
        }
        return infoDisplayContributor;
    }

    private InfoDisplayObjectProvider _getInfoDisplayObjectProvider(InfoDisplayContributor infoDisplayContributor, long groupId, String friendlyURL, Map<String, String[]> params) throws PortalException {
        long versionClassPK = this._getVersionClassPK(params);
        if (versionClassPK > 0L) {
            return infoDisplayContributor.getInfoDisplayObjectProvider(versionClassPK);
        }
        return infoDisplayContributor.getInfoDisplayObjectProvider(groupId, this._getUrlTitle(friendlyURL));
    }

    private Layout _getInfoDisplayObjectProviderLayout(InfoDisplayObjectProvider infoDisplayObjectProvider) {
        AssetDisplayPageEntry assetDisplayPageEntry = this.assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(infoDisplayObjectProvider.getGroupId(), infoDisplayObjectProvider.getClassNameId(), infoDisplayObjectProvider.getClassPK());
        if (assetDisplayPageEntry == null) {
            return null;
        }
        if (assetDisplayPageEntry.getType() != 1) {
            return this.layoutLocalService.fetchLayout(assetDisplayPageEntry.getPlid());
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryService.fetchDefaultLayoutPageTemplateEntry(infoDisplayObjectProvider.getGroupId(), infoDisplayObjectProvider.getClassNameId(), infoDisplayObjectProvider.getClassTypeId());
        if (layoutPageTemplateEntry != null) {
            return this.layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        }
        return null;
    }

    private String _getInfoURLSeparator(String friendlyURL) {
        List paths = StringUtil.split((String)friendlyURL, (char)'/');
        return '/' + (String)paths.get(0) + '/';
    }

    private String _getUrlTitle(String friendlyURL) {
        String infoURLSeparator = this._getInfoURLSeparator(friendlyURL);
        return friendlyURL.substring(infoURLSeparator.length());
    }

    private long _getVersionClassPK(Map<String, String[]> params) {
        Object[] versions = params.get("version");
        if (ArrayUtil.isEmpty((Object[])versions)) {
            return 0L;
        }
        return GetterUtil.getLong((String)versions[0]);
    }
}

