/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.portlet;

import com.liferay.asset.display.page.configuration.AssetDisplayPageConfiguration;
import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.util.LinkedAssetEntryIdsUtil;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemDetailsProvider;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.search.InfoSearchClassMapperRegistry;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.layout.seo.template.LayoutSEOTemplateProcessor;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.model.LayoutQueryStringComposite;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAssetDisplayPageFriendlyURLResolver
implements FriendlyURLResolver {
    @Reference
    protected AssetDisplayPageEntryLocalService assetDisplayPageEntryLocalService;
    @Reference
    protected AssetEntryService assetEntryLocalService;
    @Reference
    protected InfoItemServiceRegistry infoItemServiceRegistry;
    @Reference
    protected InfoSearchClassMapperRegistry infoSearchClassMapperRegistry;
    @Reference
    protected LayoutDisplayPageProviderRegistry layoutDisplayPageProviderRegistry;
    @Reference
    protected LayoutLocalService layoutLocalService;
    @Reference
    protected LayoutPageTemplateEntryService layoutPageTemplateEntryService;
    @Reference
    protected LayoutSEOTemplateProcessor layoutSEOTemplateProcessor;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(BaseAssetDisplayPageFriendlyURLResolver.class);

    public String getActualURL(long companyId, long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutQueryStringComposite layoutQueryStringComposite = this.portal.getPortletFriendlyURLMapperLayoutQueryStringComposite(friendlyURL, params, requestContext);
        friendlyURL = layoutQueryStringComposite.getFriendlyURL();
        HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
        LayoutDisplayPageProvider<?> layoutDisplayPageProvider = this.getLayoutDisplayPageProvider(friendlyURL, params);
        LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider = this.getLayoutDisplayPageObjectProvider(layoutDisplayPageProvider, groupId, friendlyURL, params);
        Object infoItem = this._getInfoItem(layoutDisplayPageObjectProvider, params);
        httpServletRequest.setAttribute("INFO_ITEM", infoItem);
        InfoItemDetailsProvider infoItemDetailsProvider = (InfoItemDetailsProvider)this.infoItemServiceRegistry.getFirstInfoItemService(InfoItemDetailsProvider.class, layoutDisplayPageObjectProvider.getClassName());
        httpServletRequest.setAttribute("INFO_ITEM_DETAILS", (Object)infoItemDetailsProvider.getInfoItemDetails(infoItem));
        httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER", layoutDisplayPageObjectProvider);
        httpServletRequest.setAttribute("LAYOUT_DISPLAY_PAGE_PROVIDER", layoutDisplayPageProvider);
        AssetEntry assetEntry = this._getAssetEntry(layoutDisplayPageObjectProvider);
        httpServletRequest.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)assetEntry);
        if (assetEntry != null) {
            LinkedAssetEntryIdsUtil.addLinkedAssetEntryId((HttpServletRequest)httpServletRequest, (long)assetEntry.getEntryId());
        }
        Locale locale = this.portal.getLocale(httpServletRequest);
        Layout layout = this.getLayoutDisplayPageObjectProviderLayout(groupId, layoutDisplayPageObjectProvider, layoutDisplayPageProvider, params);
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this.infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, layoutDisplayPageObjectProvider.getClassName());
        InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(layoutDisplayPageObjectProvider.getDisplayObject());
        String description = this._getMappedValue(layout.getTypeSettingsProperty("mapped-description"), infoItemFieldValues, locale);
        if (description == null) {
            description = layoutDisplayPageObjectProvider.getDescription(locale);
        }
        this.portal.setPageDescription(HtmlUtil.unescape((String)HtmlUtil.stripHtml((String)description)), httpServletRequest);
        this.portal.setPageKeywords(layoutDisplayPageObjectProvider.getKeywords(locale), httpServletRequest);
        String title = this._getMappedValue(layout.getTypeSettingsProperty("mapped-title"), infoItemFieldValues, locale);
        if (title == null) {
            title = layoutDisplayPageObjectProvider.getTitle(locale);
        }
        this.portal.setPageTitle(title, httpServletRequest);
        return this.portal.getLayoutActualURL(layout, mainPath) + layoutQueryStringComposite.getQueryString();
    }

    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String originalFriendlyURL;
        LayoutDisplayPageProvider<?> layoutDisplayPageProvider = this.getLayoutDisplayPageProvider(friendlyURL, params);
        LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider = this.getLayoutDisplayPageObjectProvider(layoutDisplayPageProvider, groupId, friendlyURL, params);
        if (layoutDisplayPageObjectProvider == null) {
            throw new PortalException();
        }
        Layout layout = this.getLayoutDisplayPageObjectProviderLayout(groupId, layoutDisplayPageObjectProvider, layoutDisplayPageProvider, params);
        String localizedFriendlyURL = originalFriendlyURL = this._getOriginalFriendlyURL(friendlyURL);
        String urlTitle = layoutDisplayPageObjectProvider.getURLTitle(this.getLocale(requestContext));
        if (Validator.isNotNull((String)urlTitle)) {
            localizedFriendlyURL = this.getURLSeparator() + urlTitle;
        }
        if (!Objects.equals(originalFriendlyURL, localizedFriendlyURL)) {
            return new LayoutFriendlyURLComposite(layout, localizedFriendlyURL, true);
        }
        return new LayoutFriendlyURLComposite(layout, friendlyURL, false);
    }

    protected AssetDisplayPageEntry getAssetDisplayPageEntry(long groupId, LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider) {
        return this.assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(groupId, layoutDisplayPageObjectProvider.getClassNameId(), layoutDisplayPageObjectProvider.getClassPK());
    }

    protected LayoutDisplayPageObjectProvider<?> getLayoutDisplayPageObjectProvider(LayoutDisplayPageProvider<?> layoutDisplayPageProvider, long groupId, String friendlyURL, Map<String, String[]> params) {
        return this._getLayoutDisplayPageObjectProvider(layoutDisplayPageProvider, groupId, friendlyURL, this._getVersion(params));
    }

    protected Layout getLayoutDisplayPageObjectProviderLayout(long groupId, LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider, LayoutDisplayPageProvider<?> layoutDisplayPageProvider, Map<String, String[]> params) {
        return this._getLayoutDisplayPageObjectProviderLayout(groupId, layoutDisplayPageObjectProvider, layoutDisplayPageProvider);
    }

    protected LayoutDisplayPageProvider<?> getLayoutDisplayPageProvider(String friendlyURL, Map<String, String[]> params) throws PortalException {
        return this._getLayoutDisplayPageProvider(friendlyURL);
    }

    protected Locale getLocale(Map<String, Object> requestContext) {
        HttpServletRequest httpServletRequest;
        HttpSession httpSession;
        Locale locale = (Locale)requestContext.get("LOCALE");
        if (locale == null && (locale = (Locale)(httpSession = (httpServletRequest = (HttpServletRequest)requestContext.get("request")).getSession()).getAttribute("LOCALE")) == null) {
            locale = this.portal.getLocale(httpServletRequest);
        }
        return locale;
    }

    private AssetEntry _getAssetEntry(LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider) {
        String className = this.infoSearchClassMapperRegistry.getSearchClassName(layoutDisplayPageObjectProvider.getClassName());
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null) {
            return null;
        }
        long classPK = layoutDisplayPageObjectProvider.getClassPK();
        try {
            AssetEntry assetEntry = assetRendererFactory.getAssetEntry(className, classPK);
            AssetDisplayPageConfiguration assetDisplayPageConfiguration = (AssetDisplayPageConfiguration)ConfigurationProviderUtil.getSystemConfiguration(AssetDisplayPageConfiguration.class);
            if (assetEntry != null && assetDisplayPageConfiguration.enableViewCountIncrement()) {
                this.assetEntryLocalService.incrementViewCounter(assetEntry);
            }
            return assetEntry;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private Object _getInfoItem(LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider, Map<String, String[]> params) throws NoSuchInfoItemException {
        String version = this._getVersion(params);
        if (Validator.isNull((String)version)) {
            return layoutDisplayPageObjectProvider.getDisplayObject();
        }
        ClassPKInfoItemIdentifier infoItemIdentifier = new ClassPKInfoItemIdentifier(layoutDisplayPageObjectProvider.getClassPK());
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this.infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, layoutDisplayPageObjectProvider.getClassName(), infoItemIdentifier.getInfoItemServiceFilter());
        infoItemIdentifier.setVersion(version);
        return infoItemObjectProvider.getInfoItem((InfoItemIdentifier)infoItemIdentifier);
    }

    private LayoutDisplayPageObjectProvider<?> _getLayoutDisplayPageObjectProvider(LayoutDisplayPageProvider<?> layoutDisplayPageProvider, long groupId, String friendlyURL, String version) {
        return layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(groupId, this._getUrlTitle(friendlyURL), version);
    }

    private Layout _getLayoutDisplayPageObjectProviderLayout(long groupId, LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider, LayoutDisplayPageProvider<?> layoutDisplayPageProvider) {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        AssetDisplayPageEntry assetDisplayPageEntry = this.getAssetDisplayPageEntry(groupId, layoutDisplayPageObjectProvider);
        if (assetDisplayPageEntry != null) {
            InfoItemReference infoItemReference;
            LayoutDisplayPageObjectProvider parentLayoutDisplayPageObjectProvider;
            if (assetDisplayPageEntry.getType() == 0) {
                return null;
            }
            if (assetDisplayPageEntry.getType() == 2) {
                return this.layoutLocalService.fetchLayout(assetDisplayPageEntry.getPlid());
            }
            if (layoutDisplayPageProvider.inheritable() && assetDisplayPageEntry.getType() == 3 && (parentLayoutDisplayPageObjectProvider = layoutDisplayPageProvider.getParentLayoutDisplayPageObjectProvider(infoItemReference = new InfoItemReference(layoutDisplayPageObjectProvider.getClassName(), layoutDisplayPageObjectProvider.getClassPK()))) != null) {
                return this._getLayoutDisplayPageObjectProviderLayout(groupId, parentLayoutDisplayPageObjectProvider, layoutDisplayPageProvider);
            }
        }
        if ((layoutPageTemplateEntry = this.layoutPageTemplateEntryService.fetchDefaultLayoutPageTemplateEntry(groupId, layoutDisplayPageObjectProvider.getClassNameId(), layoutDisplayPageObjectProvider.getClassTypeId())) != null) {
            return this.layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        }
        return null;
    }

    private LayoutDisplayPageProvider<?> _getLayoutDisplayPageProvider(String friendlyURL) throws PortalException {
        String urlSeparator = this._getURLSeparator(friendlyURL);
        LayoutDisplayPageProvider layoutDisplayPageProvider = this.layoutDisplayPageProviderRegistry.getLayoutDisplayPageProviderByURLSeparator(urlSeparator);
        if (layoutDisplayPageProvider == null) {
            throw new PortalException("Info display contributor is not available for " + urlSeparator);
        }
        return layoutDisplayPageProvider;
    }

    private String _getMappedValue(String template, InfoItemFieldValues infoItemFieldValues, Locale locale) {
        if (infoItemFieldValues == null || Validator.isNull((String)template)) {
            return null;
        }
        return this.layoutSEOTemplateProcessor.processTemplate(template, infoItemFieldValues, locale);
    }

    private String _getOriginalFriendlyURL(String friendlyURL) {
        int pos = friendlyURL.indexOf("/-/");
        if (pos == -1 || pos == 0) {
            return friendlyURL;
        }
        return friendlyURL.substring(0, pos);
    }

    private String _getURLSeparator(String friendlyURL) {
        List paths = StringUtil.split((String)friendlyURL, (char)'/');
        return '/' + (String)paths.get(0) + '/';
    }

    private String _getUrlTitle(String friendlyURL) {
        String urlSeparator = this._getURLSeparator(friendlyURL);
        LayoutQueryStringComposite layoutQueryStringComposite = this.portal.getPortletFriendlyURLMapperLayoutQueryStringComposite(friendlyURL, new HashMap(), new HashMap());
        String newFriendlyURL = layoutQueryStringComposite.getFriendlyURL();
        if (newFriendlyURL.startsWith(urlSeparator)) {
            return newFriendlyURL.substring(urlSeparator.length());
        }
        if (friendlyURL.startsWith(urlSeparator)) {
            return friendlyURL.substring(urlSeparator.length());
        }
        return "";
    }

    private String _getVersion(Map<String, String[]> params) {
        Object[] versions = params.get("version");
        if (ArrayUtil.isEmpty((Object[])versions)) {
            return "";
        }
        return versions[0];
    }
}

