/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.contributor;

import com.liferay.asset.display.contributor.AssetDisplayContributor;
import com.liferay.asset.display.contributor.AssetDisplayField;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class BaseAssetDisplayContributor<T>
implements AssetDisplayContributor {
    protected ResourceBundleLoader resourceBundleLoader;
    private static final Map<String, String> _assetEntryModelFieldsMap = new HashMap<String, String>();

    @Override
    public Set<AssetDisplayField> getAssetDisplayFields(long classTypeId, Locale locale) throws PortalException {
        LinkedHashSet<AssetDisplayField> assetDisplayFields = new LinkedHashSet<AssetDisplayField>();
        ResourceBundle resourceBundle = this.resourceBundleLoader.loadResourceBundle(locale);
        for (Map.Entry<String, String> entry : _assetEntryModelFieldsMap.entrySet()) {
            assetDisplayFields.add(new AssetDisplayField(entry.getKey(), LanguageUtil.get((ResourceBundle)resourceBundle, (String)entry.getValue())));
        }
        String[] assetEntryModelFields = this.getAssetEntryModelFields();
        if (assetEntryModelFields != null) {
            for (String assetEntryModelField : assetEntryModelFields) {
                assetDisplayFields.add(new AssetDisplayField(assetEntryModelField, LanguageUtil.get((ResourceBundle)resourceBundle, (String)assetEntryModelField)));
            }
        }
        List<AssetDisplayField> list = this.getClassTypeFields(classTypeId, locale);
        assetDisplayFields.addAll(list);
        return assetDisplayFields;
    }

    @Override
    public Map<String, Object> getAssetDisplayFieldsValues(AssetEntry assetEntry, Locale locale) throws PortalException {
        Map<String, Object> parameterMap = this._getDefaultParameterMap(assetEntry, locale);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)assetEntry.getClassNameId());
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        String[] assetEntryModelFields = this.getAssetEntryModelFields();
        if (assetEntryModelFields != null) {
            for (String assetEntryModelField : assetEntryModelFields) {
                parameterMap.put(assetEntryModelField, this.getFieldValue(assetRenderer.getAssetObject(), assetEntryModelField, locale));
            }
        }
        Map<String, Object> classTypeValues = this.getClassTypeValues(assetRenderer.getAssetObject(), locale);
        parameterMap.putAll(classTypeValues);
        return parameterMap;
    }

    @Override
    public String getLabel(Locale locale) {
        return ResourceActionsUtil.getModelResource((Locale)locale, (String)this.getClassName());
    }

    protected abstract String[] getAssetEntryModelFields();

    protected abstract Map<String, Object> getClassTypeValues(T var1, Locale var2);

    protected abstract Object getFieldValue(T var1, String var2, Locale var3);

    protected abstract void setResourceBundleLoader(ResourceBundleLoader var1);

    private Map<String, Object> _getDefaultParameterMap(AssetEntry assetEntry, Locale locale) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("categoryIds", assetEntry.getCategoryIds());
        parameterMap.put("description", assetEntry.getDescription(locale));
        parameterMap.put("publishDate", assetEntry.getPublishDate());
        parameterMap.put("summary", assetEntry.getSummary(locale));
        parameterMap.put("tagNames", assetEntry.getTagNames());
        parameterMap.put("title", assetEntry.getTitle(locale));
        return parameterMap;
    }

    static {
        _assetEntryModelFieldsMap.put("categoryIds", "categories");
        _assetEntryModelFieldsMap.put("description", "description");
        _assetEntryModelFieldsMap.put("publishDate", "publish-date");
        _assetEntryModelFieldsMap.put("summary", "summary");
        _assetEntryModelFieldsMap.put("tagNames", "tags");
        _assetEntryModelFieldsMap.put("title", "title");
    }
}

