/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.validator;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.asset.kernel.validator.AssetEntryValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=*"}, service={AssetEntryValidator.class})
public class CardinalityAssetEntryValidator
implements AssetEntryValidator {
    private static final Log _log = LogFactoryUtil.getLog((String)CardinalityAssetEntryValidator.class.getName());
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    private ClassNameLocalService _classNameLocalService;
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public void validate(long groupId, String className, long classPK, long classTypePK, long[] categoryIds, String[] entryNames) throws PortalException {
        long classNameId;
        Group companyGroup;
        List assetVocabularies = this._assetVocabularyLocalService.getGroupVocabularies(groupId, false);
        Group group = this._groupLocalService.getGroup(groupId);
        if (!group.isCompany() && (companyGroup = this._groupLocalService.fetchCompanyGroup(group.getCompanyId())) != null) {
            assetVocabularies = ListUtil.copy((List)assetVocabularies);
            assetVocabularies.addAll(this._assetVocabularyLocalService.getGroupVocabularies(companyGroup.getGroupId()));
        }
        if (this.isCategorizable(groupId, classNameId = this._classNameLocalService.getClassNameId(className), classPK)) {
            for (AssetVocabulary assetVocabulary : assetVocabularies) {
                this.validate(classNameId, classTypePK, categoryIds, assetVocabulary);
            }
        }
    }

    @Deprecated
    public void validate(long groupId, String className, long classTypePK, long[] categoryIds, String[] entryNames) throws PortalException {
        this.validate(groupId, className, 0L, classTypePK, categoryIds, entryNames);
    }

    protected boolean isCategorizable(long groupId, long classNameId, long classPK) {
        String className = this._portal.getClassName(classNameId);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null || !assetRendererFactory.isCategorizable()) {
            return false;
        }
        if (classPK != 0L) {
            try {
                AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
                if (!assetRenderer.isCategorizable(groupId)) {
                    return false;
                }
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Entity with ClassPK: ", String.valueOf(classPK), " and ClassNameId: ", String.valueOf(classNameId), " is not categorizable"}), (Throwable)pe);
                }
                return false;
            }
        }
        return true;
    }

    @Reference(unbind="-")
    protected void setAssetVocabularyLocalService(AssetVocabularyLocalService assetVocabularyLocalService) {
        this._assetVocabularyLocalService = assetVocabularyLocalService;
    }

    @Reference(unbind="-")
    protected void setClassNameLocalService(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    protected void validate(long classNameId, long classTypePK, long[] categoryIds, AssetVocabulary assetVocabulary) throws PortalException {
        if (!assetVocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK)) {
            return;
        }
        if (assetVocabulary.isMissingRequiredCategory(classNameId, classTypePK, categoryIds)) {
            throw new AssetCategoryException(assetVocabulary, 1);
        }
        if (!assetVocabulary.isMultiValued() && assetVocabulary.hasMoreThanOneCategorySelected(categoryIds)) {
            throw new AssetCategoryException(assetVocabulary, 2);
        }
    }
}

