/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.service;

import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRel;
import com.liferay.asset.entry.rel.service.AssetEntryAssetCategoryRelLocalService;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceWrapper;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class AssetEntryAssetCategoryRelAssetCategoryLocalServiceWrapper
extends AssetCategoryLocalServiceWrapper {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryAssetCategoryRelLocalService _assetEntryAssetCategoryRelLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;

    public AssetEntryAssetCategoryRelAssetCategoryLocalServiceWrapper() {
        super(null);
    }

    public AssetEntryAssetCategoryRelAssetCategoryLocalServiceWrapper(AssetCategoryLocalService assetCategoryLocalService) {
        super(assetCategoryLocalService);
    }

    public AssetCategory deleteCategory(AssetCategory category, boolean skipRebuildTree) throws PortalException {
        this._assetEntryAssetCategoryRelLocalService.deleteAssetEntryAssetCategoryRelByAssetCategoryId(category.getCategoryId());
        List<AssetEntry> entries = this._getAssetEntriesByAssetCategoryId(category.getCategoryId());
        this._assetEntryLocalService.reindex(entries);
        return super.deleteCategory(category, skipRebuildTree);
    }

    public List<AssetCategory> getCategories(long classNameId, long classPK) {
        AssetEntry entry = this._assetEntryLocalService.fetchEntry(classNameId, classPK);
        if (entry == null) {
            return Collections.emptyList();
        }
        return this._getAssetCategoriesByEntryId(entry.getEntryId());
    }

    public List<AssetCategory> getEntryCategories(long entryId) {
        return this._getAssetCategoriesByEntryId(entryId);
    }

    public AssetCategory mergeCategories(long fromCategoryId, long toCategoryId) throws PortalException {
        List<AssetEntry> entries = this._getAssetEntriesByAssetCategoryId(fromCategoryId);
        for (AssetEntry entry : entries) {
            this._assetEntryAssetCategoryRelLocalService.addAssetEntryAssetCategoryRel(entry.getEntryId(), toCategoryId);
        }
        return super.mergeCategories(fromCategoryId, toCategoryId);
    }

    public AssetCategory updateCategory(long userId, long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        name = ModelHintsUtil.trimString((String)AssetCategory.class.getName(), (String)"name", (String)name);
        AssetCategory category = this._assetCategoryLocalService.getCategory(categoryId);
        if (!Objects.equals(category.getName(), name)) {
            List<AssetEntry> entries = this._getAssetEntriesByAssetCategoryId(category.getCategoryId());
            this._assetEntryLocalService.reindex(entries);
        }
        return super.updateCategory(userId, categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    private List<AssetCategory> _getAssetCategoriesByEntryId(long assetEntryId) {
        List assetEntryAssetCategoryRels = this._assetEntryAssetCategoryRelLocalService.getAssetEntryAssetCategoryRelsByAssetEntryId(assetEntryId);
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>();
        for (AssetEntryAssetCategoryRel assetEntryAssetCategoryRel : assetEntryAssetCategoryRels) {
            AssetCategory category = this.fetchAssetCategory(assetEntryAssetCategoryRel.getAssetCategoryId());
            if (category == null) continue;
            categories.add(category);
        }
        return categories;
    }

    private List<AssetEntry> _getAssetEntriesByAssetCategoryId(long assetCategoryId) {
        List assetEntryAssetCategoryRels = this._assetEntryAssetCategoryRelLocalService.getAssetEntryAssetCategoryRelsByAssetCategoryId(assetCategoryId);
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        for (AssetEntryAssetCategoryRel assetEntryAssetCategoryRel : assetEntryAssetCategoryRels) {
            AssetEntry entry = this._assetEntryLocalService.fetchEntry(assetEntryAssetCategoryRel.getAssetEntryId());
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries;
    }
}

