/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.service;

import com.liferay.asset.category.property.model.AssetCategoryProperty;
import com.liferay.asset.category.property.service.AssetCategoryPropertyLocalService;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceWrapper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class AssetCategoryPropertyAssetCategoryLocalServiceWrapper
extends AssetCategoryLocalServiceWrapper {
    @Reference
    private AssetCategoryPropertyLocalService _assetCategoryPropertyLocalService;

    public AssetCategoryPropertyAssetCategoryLocalServiceWrapper() {
        super(null);
    }

    public AssetCategoryPropertyAssetCategoryLocalServiceWrapper(AssetCategoryLocalService assetCategoryLocalService) {
        super(assetCategoryLocalService);
    }

    public AssetCategory addCategory(long userId, long groupId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategory assetCategory = super.addCategory(userId, groupId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
        if (categoryProperties == null) {
            return assetCategory;
        }
        for (String categoryProperty : categoryProperties) {
            String[] categoryPropertyArray = StringUtil.split((String)categoryProperty, (String)"_KEY_VALUE_");
            if (categoryPropertyArray.length <= 1) {
                categoryPropertyArray = StringUtil.split((String)categoryProperty, (char)':');
            }
            String key = "";
            String value = "";
            if (categoryPropertyArray.length > 1) {
                key = GetterUtil.getString((String)categoryPropertyArray[0]);
                value = GetterUtil.getString((String)categoryPropertyArray[1]);
            }
            if (!Validator.isNotNull((String)key)) continue;
            this._assetCategoryPropertyLocalService.addCategoryProperty(userId, assetCategory.getCategoryId(), key, value);
        }
        return assetCategory;
    }

    public AssetCategory deleteCategory(AssetCategory category, boolean skipRebuildTree) throws PortalException {
        this._assetCategoryPropertyLocalService.deleteCategoryProperties(category.getCategoryId());
        return super.deleteCategory(category, skipRebuildTree);
    }

    public AssetCategory mergeCategories(long fromCategoryId, long toCategoryId) throws PortalException {
        List categoryProperties = this._assetCategoryPropertyLocalService.getCategoryProperties(fromCategoryId);
        for (AssetCategoryProperty fromCategoryProperty : categoryProperties) {
            AssetCategoryProperty toCategoryProperty = this._assetCategoryPropertyLocalService.fetchCategoryProperty(toCategoryId, fromCategoryProperty.getKey());
            if (toCategoryProperty != null) continue;
            fromCategoryProperty.setCategoryId(toCategoryId);
            this._assetCategoryPropertyLocalService.updateAssetCategoryProperty(fromCategoryProperty);
        }
        return super.mergeCategories(fromCategoryId, toCategoryId);
    }

    public AssetCategory updateCategory(long userId, long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        List oldCategoryProperties = this._assetCategoryPropertyLocalService.getCategoryProperties(categoryId);
        oldCategoryProperties = ListUtil.copy((List)oldCategoryProperties);
        if (categoryProperties != null) {
            for (String categoryProperty : categoryProperties) {
                String[] categoryPropertyArray = StringUtil.split((String)categoryProperty, (String)"_KEY_VALUE_");
                if (categoryPropertyArray.length <= 1) {
                    categoryPropertyArray = StringUtil.split((String)categoryProperty, (char)':');
                }
                String key = "";
                if (categoryPropertyArray.length > 0) {
                    key = GetterUtil.getString((String)categoryPropertyArray[0]);
                }
                String value = "";
                if (categoryPropertyArray.length > 1) {
                    value = GetterUtil.getString((String)categoryPropertyArray[1]);
                }
                if (!Validator.isNotNull((String)key)) continue;
                boolean addCategoryProperty = true;
                AssetCategoryProperty oldCategoryProperty = null;
                Iterator iterator = oldCategoryProperties.iterator();
                while (iterator.hasNext()) {
                    oldCategoryProperty = (AssetCategoryProperty)iterator.next();
                    if (categoryId != oldCategoryProperty.getCategoryId() || !key.equals(oldCategoryProperty.getKey())) continue;
                    addCategoryProperty = false;
                    if (!value.equals(oldCategoryProperty.getValue())) {
                        this._assetCategoryPropertyLocalService.updateCategoryProperty(userId, oldCategoryProperty.getCategoryPropertyId(), key, value);
                    }
                    iterator.remove();
                    break;
                }
                if (!addCategoryProperty) continue;
                this._assetCategoryPropertyLocalService.addCategoryProperty(userId, categoryId, key, value);
            }
        }
        for (AssetCategoryProperty categoryProperty : oldCategoryProperties) {
            this._assetCategoryPropertyLocalService.deleteAssetCategoryProperty(categoryProperty);
        }
        return super.updateCategory(userId, categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }
}

