/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class AssetCategoryUtil {
    public static List<BreadcrumbEntry> getAssetCategoriesBreadcrumbEntries(AssetVocabulary vocabulary, AssetCategory category, HttpServletRequest httpServletRequest, RenderResponse renderResponse) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        BreadcrumbEntry vocabulariesBreadcrumbEntry = new BreadcrumbEntry();
        vocabulariesBreadcrumbEntry.setTitle(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"vocabularies"));
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        vocabulariesBreadcrumbEntry.setURL(portletURL.toString());
        breadcrumbEntries.add(vocabulariesBreadcrumbEntry);
        if (category == null) {
            BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
            breadcrumbEntry.setTitle(vocabulary.getTitle(themeDisplay.getLocale()));
            breadcrumbEntries.add(breadcrumbEntry);
            return breadcrumbEntries;
        }
        BreadcrumbEntry vocabularyBreadcrumbEntry = new BreadcrumbEntry();
        portletURL.setParameter("mvcPath", "/view_categories.jsp");
        String navigation = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"navigation");
        if (Validator.isNotNull((String)navigation)) {
            portletURL.setParameter("navigation", navigation);
        }
        vocabularyBreadcrumbEntry.setTitle(vocabulary.getTitle(themeDisplay.getLocale()));
        portletURL.setParameter("vocabularyId", String.valueOf(vocabulary.getVocabularyId()));
        vocabularyBreadcrumbEntry.setURL(portletURL.toString());
        breadcrumbEntries.add(vocabularyBreadcrumbEntry);
        List ancestorsCategories = category.getAncestors();
        Collections.reverse(ancestorsCategories);
        for (AssetCategory curCategory : ancestorsCategories) {
            BreadcrumbEntry categoryBreadcrumbEntry = new BreadcrumbEntry();
            categoryBreadcrumbEntry.setTitle(curCategory.getTitle(themeDisplay.getLocale()));
            portletURL.setParameter("categoryId", String.valueOf(curCategory.getCategoryId()));
            categoryBreadcrumbEntry.setURL(portletURL.toString());
            breadcrumbEntries.add(categoryBreadcrumbEntry);
        }
        BreadcrumbEntry categoryBreadcrumbEntry = new BreadcrumbEntry();
        categoryBreadcrumbEntry.setTitle(category.getTitle(themeDisplay.getLocale()));
        breadcrumbEntries.add(categoryBreadcrumbEntry);
        return breadcrumbEntries;
    }

    public static List<BreadcrumbEntry> getAssetVocabulariesBreadcrumbEntries(HttpServletRequest httpServletRequest) {
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setTitle(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"vocabularies"));
        breadcrumbEntries.add(breadcrumbEntry);
        return breadcrumbEntries;
    }
}

