/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.portlet.configuration.icon;

import com.liferay.asset.categories.admin.web.internal.display.context.AssetCategoriesDisplayContext;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_asset_categories_admin_web_portlet_AssetCategoriesAdminPortlet", "path=/view_categories.jsp"}, service={PortletConfigurationIcon.class})
public class AssetCategoryPermissionsPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    private static final Log _log = LogFactoryUtil.getLog(AssetCategoryPermissionsPortletConfigurationIcon.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private Portal _portal;

    public String getMessage(PortletRequest portletRequest) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)"permissions");
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        long categoryId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"categoryId", (long)0L);
        if (categoryId <= 0L) {
            return "";
        }
        String url = "";
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(categoryId);
        try {
            url = PermissionsURLTag.doTag((String)"", (String)AssetCategory.class.getName(), (String)assetCategory.getTitle(themeDisplay.getLocale()), null, (String)String.valueOf(assetCategory.getCategoryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)themeDisplay.getRequest());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public double getWeight() {
        return 180.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest(portletRequest);
        AssetCategoriesDisplayContext assetCategoriesDisplayContext = new AssetCategoriesDisplayContext(null, null, httpServletRequest);
        AssetCategory category = assetCategoriesDisplayContext.getCategory();
        if (category == null) {
            return false;
        }
        try {
            return assetCategoriesDisplayContext.hasPermission(category, "PERMISSIONS");
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }

    public boolean isToolTip() {
        return false;
    }

    public boolean isUseDialog() {
        return true;
    }
}

