/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.portlet;

import com.liferay.asset.categories.admin.web.internal.configuration.AssetCategoriesAdminWebConfiguration;
import com.liferay.asset.category.property.model.AssetCategoryProperty;
import com.liferay.asset.category.property.service.AssetCategoryPropertyLocalService;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.NoSuchClassTypeException;
import com.liferay.asset.kernel.exception.AssetCategoryNameException;
import com.liferay.asset.kernel.exception.CategoryPropertyKeyException;
import com.liferay.asset.kernel.exception.CategoryPropertyValueException;
import com.liferay.asset.kernel.exception.DuplicateCategoryException;
import com.liferay.asset.kernel.exception.DuplicateCategoryPropertyException;
import com.liferay.asset.kernel.exception.DuplicateVocabularyException;
import com.liferay.asset.kernel.exception.NoSuchCategoryException;
import com.liferay.asset.kernel.exception.NoSuchEntryException;
import com.liferay.asset.kernel.exception.NoSuchVocabularyException;
import com.liferay.asset.kernel.exception.VocabularyNameException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.asset.categories.admin.web.internal.configuration.AssetCategoriesAdminWebConfiguration"}, immediate=true, property={"com.liferay.portlet.css-class-wrapper=portlet-asset-category-admin", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.icon=/icons/asset_category_admin.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.preferences-unique-per-layout=false", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Asset Category Admin", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_asset_categories_admin_web_portlet_AssetCategoriesAdminPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class AssetCategoryAdminPortlet
extends MVCPortlet {
    private AssetCategoriesAdminWebConfiguration _assetCategoriesAdminWebConfiguration;
    @Reference
    private AssetCategoryPropertyLocalService _assetCategoryPropertyLocalService;
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyService _assetVocabularyService;

    public void deleteCategory(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] deleteCategoryIds = null;
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        deleteCategoryIds = categoryId > 0L ? new long[]{categoryId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        this._assetCategoryService.deleteCategories(deleteCategoryIds);
    }

    public void deleteVocabulary(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] deleteVocabularyIds = null;
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        deleteVocabularyIds = vocabularyId > 0L ? new long[]{vocabularyId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        for (long deleteVocabularyId : deleteVocabularyIds) {
            this._assetVocabularyService.deleteVocabulary(deleteVocabularyId);
        }
    }

    public void editCategory(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetCategory.class.getName(), (PortletRequest)actionRequest);
        if (categoryId <= 0L) {
            this._assetCategoryService.addCategory(serviceContext.getScopeGroupId(), parentCategoryId, titleMap, descriptionMap, vocabularyId, null, serviceContext);
        } else {
            List categoryProperties = this._assetCategoryPropertyLocalService.getCategoryProperties(categoryId);
            String[] categoryPropertiesArray = this.getCategoryProperties(categoryProperties);
            this._assetCategoryService.updateCategory(categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryPropertiesArray, serviceContext);
        }
    }

    public void editProperties(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId", (long)0L);
        AssetCategory category = this._assetCategoryService.fetchCategory(categoryId);
        String[] categoryProperties = this.getCategoryProperties(actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetCategory.class.getName(), (PortletRequest)actionRequest);
        this._assetCategoryService.updateCategory(categoryId, category.getParentCategoryId(), category.getTitleMap(), category.getDescriptionMap(), category.getVocabularyId(), categoryProperties, serviceContext);
    }

    public void editVocabulary(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetVocabulary.class.getName(), (PortletRequest)actionRequest);
        if (vocabularyId <= 0L) {
            this._assetVocabularyService.addVocabulary(serviceContext.getScopeGroupId(), "", titleMap, descriptionMap, this.getSettings(actionRequest), serviceContext);
        } else {
            this._assetVocabularyService.updateVocabulary(vocabularyId, "", titleMap, descriptionMap, this.getSettings(actionRequest), serviceContext);
        }
    }

    public void moveCategory(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        if (vocabularyId <= 0L && parentCategoryId <= 0L) {
            throw new NoSuchVocabularyException();
        }
        if (vocabularyId <= 0L) {
            AssetCategory parentCategory = this._assetCategoryService.fetchCategory(parentCategoryId);
            vocabularyId = parentCategory.getVocabularyId();
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetCategory.class.getName(), (PortletRequest)actionRequest);
        this._assetCategoryService.moveCategory(categoryId, parentCategoryId, vocabularyId, serviceContext);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._assetCategoriesAdminWebConfiguration = (AssetCategoriesAdminWebConfiguration)ConfigurableUtil.createConfigurable(AssetCategoriesAdminWebConfiguration.class, properties);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchCategoryException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchVocabularyException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
            return;
        }
        renderRequest.setAttribute("ASSET_CATEGORIES_ADMIN_CONFIGURATION", (Object)this._assetCategoriesAdminWebConfiguration);
        super.doDispatch(renderRequest, renderResponse);
    }

    protected String[] getCategoryProperties(ActionRequest actionRequest) {
        int[] categoryPropertiesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"categoryPropertiesIndexes"), (int)0);
        String[] categoryProperties = new String[categoryPropertiesIndexes.length];
        for (int i = 0; i < categoryPropertiesIndexes.length; ++i) {
            int categoryPropertiesIndex = categoryPropertiesIndexes[i];
            String key = ParamUtil.getString((PortletRequest)actionRequest, (String)("key" + categoryPropertiesIndex));
            if (Validator.isNull((String)key)) continue;
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)("value" + categoryPropertiesIndex));
            categoryProperties[i] = key + "_KEY_VALUE_" + value;
        }
        return categoryProperties;
    }

    protected String[] getCategoryProperties(List<AssetCategoryProperty> categoryProperties) {
        String[] categoryPropertiesArray = new String[categoryProperties.size()];
        for (int i = 0; i < categoryProperties.size(); ++i) {
            AssetCategoryProperty categoryProperty = categoryProperties.get(i);
            categoryPropertiesArray[i] = categoryProperty.getKey() + "_KEY_VALUE_" + categoryProperty.getValue();
        }
        return categoryPropertiesArray;
    }

    protected String getSettings(ActionRequest actionRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetVocabularySettingsHelper vocabularySettingsHelper = new AssetVocabularySettingsHelper();
        int[] indexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"indexes"), (int)0);
        long[] classNameIds = new long[indexes.length];
        long[] classTypePKs = new long[indexes.length];
        boolean[] requireds = new boolean[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            classNameIds[i] = ParamUtil.getLong((PortletRequest)actionRequest, (String)("classNameId" + index));
            classTypePKs[i] = ParamUtil.getLong((PortletRequest)actionRequest, (String)StringBundler.concat((Object[])new Object[]{"subtype", classNameIds[i], "-classNameId", index}), (long)-1L);
            if (classTypePKs[i] != -1L) {
                AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameIds[i]);
                ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
                try {
                    classTypeReader.getClassType(classTypePKs[i], themeDisplay.getLocale());
                }
                catch (NoSuchModelException nsme) {
                    throw new NoSuchClassTypeException((Throwable)nsme);
                }
            }
            requireds[i] = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("required" + index));
        }
        vocabularySettingsHelper.setClassNameIdsAndClassTypePKs(classNameIds, classTypePKs, requireds);
        boolean multiValued = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"multiValued");
        vocabularySettingsHelper.setMultiValued(multiValued);
        return vocabularySettingsHelper.toString();
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof AssetCategoryNameException || cause instanceof CategoryPropertyKeyException || cause instanceof CategoryPropertyValueException || cause instanceof DuplicateCategoryException || cause instanceof DuplicateCategoryPropertyException || cause instanceof DuplicateVocabularyException || cause instanceof NoSuchCategoryException || cause instanceof NoSuchClassTypeException || cause instanceof NoSuchEntryException || cause instanceof NoSuchVocabularyException || cause instanceof PrincipalException || cause instanceof VocabularyNameException;
    }
}

