/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.exportimport.data.handler;

import com.liferay.asset.categories.admin.web.internal.exportimport.data.handler.AssetVocabularySettingsExportHelper;
import com.liferay.asset.categories.admin.web.internal.exportimport.data.handler.AssetVocabularySettingsImportHelper;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class AssetVocabularyStagedModelDataHandler
extends BaseStagedModelDataHandler<AssetVocabulary> {
    public static final String[] CLASS_NAMES = new String[]{AssetVocabulary.class.getName()};
    private static final String _SETTINGS_METADATA = "settings-metadata";
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public void deleteStagedModel(AssetVocabulary vocabulary) throws PortalException {
        this._assetVocabularyLocalService.deleteVocabulary(vocabulary);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        AssetVocabulary vocabulary = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (vocabulary != null) {
            this.deleteStagedModel(vocabulary);
        }
    }

    public AssetVocabulary fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._assetVocabularyLocalService.fetchAssetVocabularyByUuidAndGroupId(uuid, groupId);
    }

    public List<AssetVocabulary> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._assetVocabularyLocalService.getAssetVocabulariesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(AssetVocabulary vocabulary) {
        return vocabulary.getTitleCurrentValue();
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        String displayName = referenceElement.attributeValue("display-name");
        return this.validateMissingReference(uuid, groupId, displayName);
    }

    protected ServiceContext createServiceContext(PortletDataContext portletDataContext, AssetVocabulary vocabulary) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(vocabulary.getCreateDate());
        serviceContext.setModifiedDate(vocabulary.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        return serviceContext;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, AssetVocabulary vocabulary) throws Exception {
        Locale locale = this._portal.getSiteDefaultLocale(portletDataContext.getScopeGroupId());
        Element vocabularyElement = portletDataContext.getExportDataElement((ClassedModel)vocabulary);
        String vocabularyPath = ExportImportPathUtil.getModelPath((StagedModel)vocabulary);
        vocabularyElement.addAttribute("path", vocabularyPath);
        vocabulary.setUserUuid(vocabulary.getUserUuid());
        this.exportSettingsMetadata(portletDataContext, vocabulary, vocabularyElement, locale);
        portletDataContext.addReferenceElement((ClassedModel)vocabulary, vocabularyElement, (ClassedModel)vocabulary, "dependency", false);
        portletDataContext.addPermissions(AssetVocabulary.class, vocabulary.getVocabularyId());
        portletDataContext.addZipEntry(vocabularyPath, (Object)vocabulary);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long vocabularyId) throws Exception {
        AssetVocabulary existingVocabulary = (AssetVocabulary)this.fetchMissingReference(uuid, groupId);
        if (existingVocabulary == null) {
            return;
        }
        Map vocabularyIds = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class);
        vocabularyIds.put(vocabularyId, existingVocabulary.getVocabularyId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, AssetVocabulary vocabulary) throws Exception {
        String name;
        long userId = portletDataContext.getUserId(vocabulary.getUserUuid());
        ServiceContext serviceContext = this.createServiceContext(portletDataContext, vocabulary);
        vocabulary.setSettings(this.getImportSettings(portletDataContext, vocabulary));
        AssetVocabulary importedVocabulary = null;
        AssetVocabulary existingVocabulary = this.fetchStagedModelByUuidAndGroupId(vocabulary.getUuid(), portletDataContext.getScopeGroupId());
        if (existingVocabulary == null) {
            name = this.getVocabularyName(null, portletDataContext.getScopeGroupId(), vocabulary.getName(), 2);
            serviceContext.setUuid(vocabulary.getUuid());
            importedVocabulary = this._assetVocabularyLocalService.addVocabulary(userId, portletDataContext.getScopeGroupId(), "", this.getVocabularyTitleMap(portletDataContext.getScopeGroupId(), vocabulary, name), vocabulary.getDescriptionMap(), vocabulary.getSettings(), serviceContext);
        } else {
            name = this.getVocabularyName(vocabulary.getUuid(), portletDataContext.getScopeGroupId(), vocabulary.getName(), 2);
            importedVocabulary = this._assetVocabularyLocalService.updateVocabulary(existingVocabulary.getVocabularyId(), "", this.getVocabularyTitleMap(portletDataContext.getScopeGroupId(), vocabulary, name), vocabulary.getDescriptionMap(), vocabulary.getSettings(), serviceContext);
        }
        Map vocabularyIds = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class);
        vocabularyIds.put(vocabulary.getVocabularyId(), importedVocabulary.getVocabularyId());
        portletDataContext.importPermissions(AssetVocabulary.class, vocabulary.getVocabularyId(), importedVocabulary.getVocabularyId());
    }

    protected void exportSettingsMetadata(PortletDataContext portletDataContext, AssetVocabulary vocabulary, Element vocabularyElement, Locale locale) throws PortalException {
        String settingsMetadataPath = ExportImportPathUtil.getModelPath((StagedModel)vocabulary, (String)"settings-metadata.json");
        vocabularyElement.addAttribute(_SETTINGS_METADATA, settingsMetadataPath);
        AssetVocabularySettingsExportHelper assetVocabularySettingsExportHelper = new AssetVocabularySettingsExportHelper(vocabulary.getSettings(), this._jsonFactory, locale);
        portletDataContext.addZipEntry(settingsMetadataPath, assetVocabularySettingsExportHelper.getSettingsMetadata());
    }

    protected String getImportSettings(PortletDataContext portletDataContext, AssetVocabulary vocabulary) throws PortalException {
        Element vocabularyElement = portletDataContext.getImportDataElement((StagedModel)vocabulary);
        JSONObject settingsMetadataJSONObject = this.getImportSettingsMetadataJSONObject(portletDataContext, vocabularyElement);
        if (settingsMetadataJSONObject.length() == 0) {
            return vocabulary.getSettings();
        }
        long groupId = portletDataContext.getScopeGroupId();
        long[] groupIds = new long[]{portletDataContext.getCompanyGroupId(), groupId};
        Locale locale = this._portal.getSiteDefaultLocale(groupId);
        AssetVocabularySettingsImportHelper assetVocabularySettingsImportHelper = new AssetVocabularySettingsImportHelper(vocabulary.getSettings(), this._classNameLocalService, groupIds, locale, settingsMetadataJSONObject);
        return assetVocabularySettingsImportHelper.getSettings();
    }

    protected JSONObject getImportSettingsMetadataJSONObject(PortletDataContext portletDataContext, Element vocabularyElement) throws PortalException {
        String settingsMetadataPath = vocabularyElement.attributeValue(_SETTINGS_METADATA);
        String serializedSettingsMetadata = portletDataContext.getZipEntryAsString(settingsMetadataPath);
        return this._jsonFactory.createJSONObject(serializedSettingsMetadata);
    }

    protected String getVocabularyName(String uuid, long groupId, String name, int count) throws Exception {
        AssetVocabulary vocabulary = this._assetVocabularyLocalService.fetchGroupVocabulary(groupId, name);
        if (vocabulary == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(vocabulary.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getVocabularyName(uuid, groupId, name, ++count);
    }

    protected Map<Locale, String> getVocabularyTitleMap(long groupId, AssetVocabulary vocabulary, String name) throws PortalException {
        Map titleMap = vocabulary.getTitleMap();
        Locale locale = this._portal.getSiteDefaultLocale(groupId);
        if (titleMap.isEmpty() || !Objects.equals(vocabulary.getName(), name) || !titleMap.containsKey(locale)) {
            titleMap.put(locale, name);
        }
        return titleMap;
    }

    protected boolean validateMissingReference(String uuid, long groupId, String name) {
        AssetVocabulary existingStagedModel = (AssetVocabulary)this.fetchMissingReference(uuid, groupId);
        if (existingStagedModel == null) {
            existingStagedModel = this._assetVocabularyLocalService.fetchGroupVocabulary(groupId, name);
        }
        return existingStagedModel != null;
    }
}

