/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.exportimport.data.handler;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.List;
import java.util.Locale;

public class AssetVocabularySettingsImportHelper
extends AssetVocabularySettingsHelper {
    private static final Log _log = LogFactoryUtil.getLog(AssetVocabularySettingsImportHelper.class);
    private long[] _classNameIds = new long[0];
    private final ClassNameLocalService _classNameLocalService;
    private long[] _classTypePKs = new long[0];
    private final long[] _groupIds;
    private final Locale _locale;
    private boolean[] _requireds = new boolean[0];
    private final JSONObject _settingsMetadataJSONObject;

    public AssetVocabularySettingsImportHelper(String settings, ClassNameLocalService classNameLocalService, long[] groupIds, Locale locale, JSONObject settingsMetadataJSONObject) {
        super(settings);
        this._classNameLocalService = classNameLocalService;
        this._groupIds = groupIds;
        this._locale = locale;
        this._settingsMetadataJSONObject = settingsMetadataJSONObject;
        this.updateSettings();
    }

    public String getSettings() {
        return super.toString();
    }

    public void updateSettings() {
        this.fillClassNameIdsAndClassTypePKs(this.getClassNameIdsAndClassTypePKs(), false);
        this.fillClassNameIdsAndClassTypePKs(this.getRequiredClassNameIdsAndClassTypePKs(), true);
        this.setClassNameIdsAndClassTypePKs(this._classNameIds, this._classTypePKs, this._requireds);
    }

    protected boolean existClassName(long classNameId) {
        if (classNameId == 0L) {
            return false;
        }
        JSONObject metadataJSONObject = this.getMetadataJSONObject(classNameId);
        String className = metadataJSONObject.getString("className");
        if (this._classNameLocalService.fetchClassName(className) != null) {
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("No class name found for " + className));
        }
        return false;
    }

    protected void fillClassNameIdsAndClassTypePKs(String[] classNameIdsAndClassTypePKs, boolean required) {
        for (String classNameIdAndClassTypePK : classNameIdsAndClassTypePKs) {
            long oldClassNameId = this.getClassNameId(classNameIdAndClassTypePK);
            if (!this.existClassName(oldClassNameId)) continue;
            long newClassNameId = this.getNewClassNameId(oldClassNameId);
            this._classNameIds = ArrayUtil.append((long[])this._classNameIds, (long)newClassNameId);
            long oldClassTypePK = this.getClassTypePK(classNameIdAndClassTypePK);
            long newClassTypePK = this.getNewClassTypePK(oldClassNameId, newClassNameId, oldClassTypePK);
            this._classTypePKs = ArrayUtil.append((long[])this._classTypePKs, (long)newClassTypePK);
            this._requireds = ArrayUtil.append((boolean[])this._requireds, (boolean)required);
        }
    }

    protected JSONObject getMetadataJSONObject(long classNameId) {
        return this._settingsMetadataJSONObject.getJSONObject(String.valueOf(classNameId));
    }

    protected long getNewClassNameId(long classNameId) {
        if (classNameId == 0L) {
            return 0L;
        }
        JSONObject metadataJSONObject = this.getMetadataJSONObject(classNameId);
        String className = metadataJSONObject.getString("className");
        return this._classNameLocalService.getClassNameId(className);
    }

    protected long getNewClassTypePK(long oldClassNameId, long newClassNameId, long oldClassTypePK) {
        if (oldClassTypePK == -1L) {
            return -1L;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)newClassNameId);
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        List availableClassTypes = classTypeReader.getAvailableClassTypes(this._groupIds, this._locale);
        JSONObject metadataJSONObject = this.getMetadataJSONObject(oldClassNameId);
        JSONObject classTypesJSONObject = metadataJSONObject.getJSONObject("classTypes");
        String classTypeName = classTypesJSONObject.getString(String.valueOf(oldClassTypePK));
        for (ClassType classType : availableClassTypes) {
            String curClassTypeName = classType.getName();
            if (!curClassTypeName.equals(classTypeName)) continue;
            return classType.getClassTypeId();
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("No class type found for " + classTypeName));
        }
        return -1L;
    }
}

