/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.exportimport.data.handler;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.Locale;

public class AssetVocabularySettingsExportHelper
extends AssetVocabularySettingsHelper {
    private final JSONFactory _jsonFactory;
    private final Locale _locale;

    public AssetVocabularySettingsExportHelper(String settings, JSONFactory jsonFactory, Locale locale) {
        super(settings);
        this._jsonFactory = jsonFactory;
        this._locale = locale;
    }

    public String getSettingsMetadata() throws PortalException {
        JSONObject settingsMetadataJSONObject = this.createSettingsMetadataJSONObject();
        return settingsMetadataJSONObject.toJSONString();
    }

    protected JSONObject createSettingsMetadataJSONObject() throws PortalException {
        JSONObject settingsMetadataJSONObject = this._jsonFactory.createJSONObject();
        String settings = this.getSettings();
        if (Validator.isNotNull((String)settings)) {
            String[] classNameIdsAndClassTypePKs;
            for (String classNameIdAndClassTypePK : classNameIdsAndClassTypePKs = (String[])ArrayUtil.append((Object[])this.getRequiredClassNameIdsAndClassTypePKs(), (Object[])this.getClassNameIdsAndClassTypePKs())) {
                long classNameId = this.getClassNameId(classNameIdAndClassTypePK);
                if (classNameId == 0L) continue;
                long classTypePK = this.getClassTypePK(classNameIdAndClassTypePK);
                JSONObject classTypeJSONObject = this.getClassTypeJSONObject(settingsMetadataJSONObject, classNameId);
                this.putClassTypeJSONObject(classTypeJSONObject, classNameId, classTypePK);
            }
        }
        return settingsMetadataJSONObject;
    }

    protected JSONObject getClassTypeJSONObject(JSONObject settingsMetadataJSONObject, long classNameId) {
        JSONObject classTypeJSONObject = null;
        JSONObject metadataJSONObject = settingsMetadataJSONObject.getJSONObject(String.valueOf(classNameId));
        if (metadataJSONObject != null) {
            classTypeJSONObject = metadataJSONObject.getJSONObject("classTypes");
        } else {
            metadataJSONObject = this._jsonFactory.createJSONObject();
            settingsMetadataJSONObject.put(String.valueOf(classNameId), metadataJSONObject);
            metadataJSONObject.put("className", PortalUtil.getClassName((long)classNameId));
            classTypeJSONObject = this._jsonFactory.createJSONObject();
            metadataJSONObject.put("classTypes", classTypeJSONObject);
        }
        return classTypeJSONObject;
    }

    protected String getSettings() {
        return super.toString();
    }

    protected void putClassTypeJSONObject(JSONObject classTypeJSONObject, long classNameId, long classTypePK) throws PortalException {
        if (classTypePK == -1L) {
            return;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameId);
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(classTypePK, this._locale);
        classTypeJSONObject.put(String.valueOf(classTypePK), classType.getName());
    }
}

