/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.exportimport.data.handler;

import com.liferay.asset.category.property.model.AssetCategoryProperty;
import com.liferay.asset.category.property.service.AssetCategoryPropertyLocalService;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class AssetCategoryStagedModelDataHandler
extends BaseStagedModelDataHandler<AssetCategory> {
    public static final String[] CLASS_NAMES = new String[]{AssetCategory.class.getName()};
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetCategoryPropertyLocalService _assetCategoryPropertyLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private Portal _portal;

    public void deleteStagedModel(AssetCategory category) throws PortalException {
        this._assetCategoryLocalService.deleteCategory(category);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        AssetCategory category = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (category != null) {
            this.deleteStagedModel(category);
        }
    }

    public AssetCategory fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._assetCategoryLocalService.fetchAssetCategoryByUuidAndGroupId(uuid, groupId);
    }

    public List<AssetCategory> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._assetCategoryLocalService.getAssetCategoriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(AssetCategory category) {
        return category.getTitleCurrentValue();
    }

    protected ServiceContext createServiceContext(PortletDataContext portletDataContext, AssetCategory category) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(category.getCreateDate());
        serviceContext.setModifiedDate(category.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        return serviceContext;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, AssetCategory category) throws Exception {
        if (category.getParentCategoryId() != 0L) {
            AssetCategory parentCategory = this._assetCategoryLocalService.fetchAssetCategory(category.getParentCategoryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)category, (StagedModel)parentCategory, (String)"parent");
        } else {
            AssetVocabulary vocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(category.getVocabularyId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)category, (StagedModel)vocabulary, (String)"parent");
        }
        Element categoryElement = portletDataContext.getExportDataElement((ClassedModel)category);
        category.setUserUuid(category.getUserUuid());
        List categoryProperties = this._assetCategoryPropertyLocalService.getCategoryProperties(category.getCategoryId());
        for (AssetCategoryProperty categoryProperty : categoryProperties) {
            Element propertyElement = categoryElement.addElement("property");
            propertyElement.addAttribute("userUuid", categoryProperty.getUserUuid());
            propertyElement.addAttribute("key", categoryProperty.getKey());
            propertyElement.addAttribute("value", categoryProperty.getValue());
        }
        String categoryPath = ExportImportPathUtil.getModelPath((StagedModel)category);
        categoryElement.addAttribute("path", categoryPath);
        portletDataContext.addReferenceElement((ClassedModel)category, categoryElement, (ClassedModel)category, "dependency", false);
        portletDataContext.addPermissions(AssetCategory.class, category.getCategoryId());
        portletDataContext.addZipEntry(categoryPath, (Object)category);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long categoryId) throws Exception {
        AssetCategory existingCategory = (AssetCategory)this.fetchMissingReference(uuid, groupId);
        if (existingCategory == null) {
            return;
        }
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class);
        categoryIds.put(categoryId, existingCategory.getCategoryId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, AssetCategory category) throws Exception {
        String name;
        long userId = portletDataContext.getUserId(category.getUserUuid());
        Map vocabularyIds = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class);
        long vocabularyId = MapUtil.getLong((Map)vocabularyIds, (long)category.getVocabularyId(), (long)category.getVocabularyId());
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        Element categoryElement = portletDataContext.getImportDataElement((StagedModel)category);
        List propertyElements = categoryElement.elements("property");
        String[] properties = new String[propertyElements.size()];
        for (int i = 0; i < propertyElements.size(); ++i) {
            Element propertyElement = (Element)propertyElements.get(i);
            String key = propertyElement.attributeValue("key");
            String value = propertyElement.attributeValue("value");
            properties[i] = key.concat("_KEY_VALUE_").concat(value);
        }
        ServiceContext serviceContext = this.createServiceContext(portletDataContext, category);
        AssetCategory importedCategory = null;
        AssetCategory existingCategory = this.fetchStagedModelByUuidAndGroupId(category.getUuid(), portletDataContext.getScopeGroupId());
        if (existingCategory == null) {
            name = this.getCategoryName(null, portletDataContext.getScopeGroupId(), parentCategoryId, category.getName(), vocabularyId, 2);
            serviceContext.setUuid(category.getUuid());
            importedCategory = this._assetCategoryLocalService.addCategory(userId, portletDataContext.getScopeGroupId(), parentCategoryId, this.getCategoryTitleMap(portletDataContext.getScopeGroupId(), category, name), category.getDescriptionMap(), vocabularyId, properties, serviceContext);
        } else {
            name = this.getCategoryName(category.getUuid(), portletDataContext.getScopeGroupId(), parentCategoryId, category.getName(), vocabularyId, 2);
            importedCategory = this._assetCategoryLocalService.updateCategory(userId, existingCategory.getCategoryId(), parentCategoryId, this.getCategoryTitleMap(portletDataContext.getScopeGroupId(), category, name), category.getDescriptionMap(), vocabularyId, properties, serviceContext);
        }
        categoryIds.put(category.getCategoryId(), importedCategory.getCategoryId());
        Map categoryUuids = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class + ".uuid");
        categoryUuids.put(category.getUuid(), importedCategory.getUuid());
        portletDataContext.importPermissions(AssetCategory.class, category.getCategoryId(), importedCategory.getCategoryId());
    }

    protected String getCategoryName(String uuid, long groupId, long parentCategoryId, String name, long vocabularyId, int count) throws Exception {
        AssetCategory category = this._assetCategoryLocalService.fetchCategory(groupId, parentCategoryId, name, vocabularyId);
        if (category == null || Validator.isNotNull((String)uuid) && uuid.equals(category.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getCategoryName(uuid, groupId, parentCategoryId, name, vocabularyId, ++count);
    }

    protected Map<Locale, String> getCategoryTitleMap(long groupId, AssetCategory category, String name) throws PortalException {
        Map titleMap = category.getTitleMap();
        Locale locale = this._portal.getSiteDefaultLocale(groupId);
        if (titleMap.isEmpty() || !Objects.equals(category.getName(), name) || !titleMap.containsKey(locale)) {
            titleMap.put(locale, name);
        }
        return titleMap;
    }
}

