/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.exportimport.data.handler;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_asset_categories_admin_web_portlet_AssetCategoriesAdminPortlet"}, service={PortletDataHandler.class})
public class AssetCategoryPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "asset_category";
    public static final String SCHEMA_VERSION = "1.0.0";
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private Staging _staging;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    @Activate
    protected void activate() {
        this.setDataAlwaysStaged(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(AssetCategory.class), new StagedModelType(AssetVocabulary.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "categories", true, false, null, AssetCategory.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "vocabularies", true, false, null, AssetVocabulary.class.getName())});
        this.setPublishToLiveByDefault(true);
        this.setRank(110);
        this.setStagingControls(this.getExportControls());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(AssetCategoryPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._assetVocabularyLocalService.deleteVocabularies(portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "categories")) {
            ExportActionableDynamicQuery categoryActionableDynamicQuery = this._assetCategoryLocalService.getExportActionableDynamicQuery(portletDataContext);
            categoryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "vocabularies")) {
            ExportActionableDynamicQuery vocabularyActionableDynamicQuery = this._assetVocabularyLocalService.getExportActionableDynamicQuery(portletDataContext);
            vocabularyActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        if (portletDataContext.getBooleanParameter(NAMESPACE, "categories")) {
            Element categoriesElement = portletDataContext.getImportDataGroupElement(AssetCategory.class);
            List categoryElements = categoriesElement.elements();
            for (Element categoryElement : categoryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)categoryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "vocabularies")) {
            Element vocabulariesElement = portletDataContext.getImportDataGroupElement(AssetVocabulary.class);
            List vocabularyElements = vocabulariesElement.elements();
            for (Element vocabularyElement : vocabularyElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)vocabularyElement);
            }
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(AssetCategory.class.getName()), new StagedModelType(AssetVocabulary.class.getName())});
            return;
        }
        ExportActionableDynamicQuery categoryActionableDynamicQuery = this._assetCategoryLocalService.getExportActionableDynamicQuery(portletDataContext);
        categoryActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery vocabularyActionableDynamicQuery = this._assetVocabularyLocalService.getExportActionableDynamicQuery(portletDataContext);
        vocabularyActionableDynamicQuery.performCount();
    }
}

