/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.display.context;

import com.liferay.asset.categories.admin.web.internal.display.context.AssetCategoriesDisplayContext;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.frontend.taglib.clay.servlet.taglib.display.context.SearchContainerManagementToolbarDisplayContext;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class AssetCategoriesManagementToolbarDisplayContext
extends SearchContainerManagementToolbarDisplayContext {
    private final AssetCategoriesDisplayContext _assetCategoriesDisplayContext;

    public AssetCategoriesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, AssetCategoriesDisplayContext assetCategoriesDisplayContext) throws PortalException {
        super(liferayPortletRequest, liferayPortletResponse, httpServletRequest, assetCategoriesDisplayContext.getCategoriesSearchContainer());
        this._assetCategoriesDisplayContext = assetCategoriesDisplayContext;
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteSelectedCategories");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetCategoriesManagementToolbarDisplayContext.this.request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getAvailableActions(AssetCategory category) throws PortalException {
        if (this._assetCategoriesDisplayContext.hasPermission(category, "UPDATE")) {
            return "deleteSelectedCategories";
        }
        return "";
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("navigation", "all");
        clearResultsURL.setParameter("categoryId", "0");
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getComponentId() {
        return "assetCategoriesManagementToolbar";
    }

    public CreationMenu getCreationMenu() {
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    PortletURL addCategoryURL = AssetCategoriesManagementToolbarDisplayContext.this.liferayPortletResponse.createRenderURL();
                    addCategoryURL.setParameter("mvcPath", "/edit_category.jsp");
                    if (AssetCategoriesManagementToolbarDisplayContext.this._assetCategoriesDisplayContext.getCategoryId() > 0L) {
                        addCategoryURL.setParameter("parentCategoryId", String.valueOf(AssetCategoriesManagementToolbarDisplayContext.this._assetCategoriesDisplayContext.getCategoryId()));
                    }
                    addCategoryURL.setParameter("vocabularyId", String.valueOf(AssetCategoriesManagementToolbarDisplayContext.this._assetCategoriesDisplayContext.getVocabularyId()));
                    dropdownItem.setHref((Object)addCategoryURL);
                    String label = "add-category";
                    if (AssetCategoriesManagementToolbarDisplayContext.this._assetCategoriesDisplayContext.getCategoryId() > 0L) {
                        label = "add-subcategory";
                    }
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetCategoriesManagementToolbarDisplayContext.this.request, (String)label));
                });
            }
        };
    }

    public String getDefaultEventHandler() {
        return "assetCategoriesManagementToolbarDefaultEventHandler";
    }

    public List<LabelItem> getFilterLabelItems() {
        if (!this._isNavigationCategory()) {
            return null;
        }
        final AssetCategory category = this._assetCategoriesDisplayContext.getCategory();
        if (category == null) {
            return null;
        }
        final ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new LabelItemList(){
            {
                this.add(labelItem -> labelItem.setLabel(category.getTitle(themeDisplay.getLocale())));
            }
        };
    }

    public List<DropdownItem> getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(AssetCategoriesManagementToolbarDisplayContext.this._isNavigationAll());
                    dropdownItem.setHref(AssetCategoriesManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetCategoriesManagementToolbarDisplayContext.this.request, (String)"all"));
                });
                if (AssetCategoriesManagementToolbarDisplayContext.this._assetCategoriesDisplayContext.isFlattenedNavigationAllowed()) {
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(AssetCategoriesManagementToolbarDisplayContext.this._isNavigationCategory());
                        dropdownItem.putData("action", "selectCategory");
                        dropdownItem.putData("categoriesSelectorURL", AssetCategoriesManagementToolbarDisplayContext.this._getCategoriesSelectorURL());
                        dropdownItem.putData("viewCategoriesURL", AssetCategoriesManagementToolbarDisplayContext.this._getViewCategoriesURL());
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetCategoriesManagementToolbarDisplayContext.this.request, (String)"category"));
                    });
                }
            }
        };
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public String getSearchContainerId() {
        return "assetCategories";
    }

    public Boolean isShowCreationMenu() {
        return this._assetCategoriesDisplayContext.isShowCategoriesAddButton();
    }

    protected String[] getDisplayViews() {
        if (this._assetCategoriesDisplayContext.isFlattenedNavigationAllowed()) {
            return new String[0];
        }
        return new String[]{"list", "descriptive"};
    }

    protected String[] getOrderByKeys() {
        if (this._assetCategoriesDisplayContext.isFlattenedNavigationAllowed()) {
            return new String[]{"path"};
        }
        return new String[]{"create-date"};
    }

    private String _getCategoriesSelectorURL() throws Exception {
        PortletURL portletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)this.request, (String)AssetCategory.class.getName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
        portletURL.setParameter("vocabularyIds", String.valueOf(this._assetCategoriesDisplayContext.getVocabularyId()));
        portletURL.setParameter("eventName", this.liferayPortletResponse.getNamespace() + "selectCategory");
        portletURL.setParameter("singleSelect", Boolean.TRUE.toString());
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return portletURL.toString();
    }

    private String _getViewCategoriesURL() {
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_categories.jsp");
        portletURL.setParameter("navigation", "category");
        portletURL.setParameter("vocabularyId", String.valueOf(this._assetCategoriesDisplayContext.getVocabularyId()));
        return portletURL.toString();
    }

    private boolean _isNavigationAll() {
        return !this._assetCategoriesDisplayContext.isFlattenedNavigationAllowed() || Objects.equals(this.getNavigation(), "all");
    }

    private boolean _isNavigationCategory() {
        return this._assetCategoriesDisplayContext.isFlattenedNavigationAllowed() && Objects.equals(this.getNavigation(), "category");
    }
}

