/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.admin.web.internal.display.context;

import com.liferay.asset.categories.admin.web.internal.configuration.AssetCategoriesAdminWebConfiguration;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryDisplay;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.AssetVocabularyDisplay;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetCategoryServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyServiceUtil;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.permission.AssetCategoriesPermission;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import com.liferay.portlet.asset.util.comparator.AssetCategoryCreateDateComparator;
import com.liferay.portlet.asset.util.comparator.AssetCategoryLeftCategoryIdComparator;
import com.liferay.portlet.asset.util.comparator.AssetVocabularyCreateDateComparator;
import java.util.List;
import java.util.Locale;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class AssetCategoriesDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(AssetCategoriesDisplayContext.class);
    private final AssetCategoriesAdminWebConfiguration _assetCategoriesAdminWebConfiguration;
    private SearchContainer _categoriesSearchContainer;
    private AssetCategory _category;
    private Long _categoryId;
    private String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private String _selectCategoryURL;
    private SearchContainer _vocabulariesSearchContainer;
    private AssetVocabulary _vocabulary;
    private Long _vocabularyId;

    public AssetCategoriesDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest httpServletRequest) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = httpServletRequest;
        this._assetCategoriesAdminWebConfiguration = (AssetCategoriesAdminWebConfiguration)this._httpServletRequest.getAttribute("ASSET_CATEGORIES_ADMIN_CONFIGURATION");
    }

    public List<NavigationItem> getAssetCategoriesNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref(AssetCategoriesDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/view_categories.jsp", "vocabularyId", String.valueOf(AssetCategoriesDisplayContext.this.getVocabularyId())});
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetCategoriesDisplayContext.this._httpServletRequest, (String)"categories"));
                });
            }
        };
    }

    public String getAssetType(AssetVocabulary vocabulary) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] selectedClassNameIds = vocabulary.getSelectedClassNameIds();
        long[] selectedClassTypePKs = vocabulary.getSelectedClassTypePKs();
        StringBundler sb = new StringBundler();
        for (int i = 0; i < selectedClassNameIds.length; ++i) {
            String name;
            long classTypePK;
            long classNameId;
            block7: {
                classNameId = selectedClassNameIds[i];
                classTypePK = selectedClassTypePKs[i];
                name = LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"all-asset-types");
                if (classNameId != 0L) {
                    if (classTypePK != -1L) {
                        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameId);
                        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
                        try {
                            ClassType classType = classTypeReader.getClassType(classTypePK, themeDisplay.getLocale());
                            name = classType.getName();
                            break block7;
                        }
                        catch (NoSuchModelException nsme) {
                            if (!_log.isDebugEnabled()) continue;
                            _log.debug((Object)("Unable to get asset type for class type primary key " + classTypePK), (Throwable)nsme);
                            continue;
                        }
                    }
                    name = ResourceActionsUtil.getModelResource((Locale)themeDisplay.getLocale(), (String)PortalUtil.getClassName((long)classNameId));
                }
            }
            sb.append(name);
            if (vocabulary.isRequired(classNameId, classTypePK)) {
                sb.append(" ");
                sb.append("*");
            }
            sb.append(", ");
        }
        if (sb.index() == 0) {
            return "";
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public List<NavigationItem> getAssetVocabulariesNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)AssetCategoriesDisplayContext.this._renderResponse.createRenderURL());
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetCategoriesDisplayContext.this._httpServletRequest, (String)"vocabularies"));
                });
            }
        };
    }

    public SearchContainer getCategoriesSearchContainer() throws PortalException {
        if (this._categoriesSearchContainer != null) {
            return this._categoriesSearchContainer;
        }
        SearchContainer categoriesSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this._getIteratorURL(), null, "there-are-no-categories");
        categoriesSearchContainer.setOrderByCol(this._getOrderByCol());
        boolean orderByAsc = false;
        String orderByType = this.getOrderByType();
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        AssetCategoryCreateDateComparator orderByComparator = new AssetCategoryCreateDateComparator(orderByAsc);
        categoriesSearchContainer.setOrderByComparator((OrderByComparator)orderByComparator);
        categoriesSearchContainer.setOrderByType(orderByType);
        EmptyOnClickRowChecker emptyOnClickRowChecker = new EmptyOnClickRowChecker((PortletResponse)this._renderResponse);
        StringBundler sb = new StringBundler(7);
        sb.append("^(?!.*");
        sb.append(this._renderResponse.getNamespace());
        sb.append("redirect).*(/vocabulary/");
        sb.append(this.getVocabularyId());
        sb.append("/category/");
        sb.append(this.getCategoryId());
        sb.append(")");
        emptyOnClickRowChecker.setRememberCheckBoxStateURLRegex(sb.toString());
        categoriesSearchContainer.setRowChecker((RowChecker)emptyOnClickRowChecker);
        List categories = null;
        int categoriesCount = 0;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = themeDisplay.getScopeGroupId();
        if (Validator.isNotNull((String)this._getKeywords())) {
            AssetCategoryDisplay assetCategoryDisplay = null;
            Sort sort = null;
            sort = this.isFlattenedNavigationAllowed() ? new Sort("leftCategoryId", 4, orderByAsc) : new Sort("createDate", 6, orderByAsc);
            assetCategoryDisplay = AssetCategoryServiceUtil.searchCategoriesDisplay((long[])new long[]{scopeGroupId}, (String)this._getKeywords(), (long[])new long[]{this.getVocabularyId()}, (long[])new long[0], (int)categoriesSearchContainer.getStart(), (int)categoriesSearchContainer.getEnd(), (Sort)sort);
            categoriesCount = assetCategoryDisplay.getTotal();
            categoriesSearchContainer.setTotal(categoriesCount);
            categories = assetCategoryDisplay.getCategories();
        } else if (this.isFlattenedNavigationAllowed()) {
            AssetCategory category = this.getCategory();
            if (category == null) {
                categoriesCount = AssetCategoryServiceUtil.getVocabularyCategoriesCount((long)themeDisplay.getScopeGroupId(), (long)this.getVocabularyId());
                categories = AssetCategoryServiceUtil.getVocabularyCategories((long)this.getVocabularyId(), (int)categoriesSearchContainer.getStart(), (int)categoriesSearchContainer.getEnd(), (OrderByComparator)new AssetCategoryLeftCategoryIdComparator(orderByAsc));
            } else {
                categoriesCount = AssetCategoryServiceUtil.getVocabularyCategoriesCount((long)themeDisplay.getScopeGroupId(), (long)category.getCategoryId(), (long)this.getVocabularyId());
                categories = AssetCategoryServiceUtil.getVocabularyCategories((long)category.getCategoryId(), (long)this.getVocabularyId(), (int)categoriesSearchContainer.getStart(), (int)categoriesSearchContainer.getEnd(), (OrderByComparator)new AssetCategoryLeftCategoryIdComparator(orderByAsc));
            }
            categoriesSearchContainer.setTotal(categoriesCount);
        } else {
            categoriesCount = AssetCategoryServiceUtil.getVocabularyCategoriesCount((long)scopeGroupId, (long)this.getCategoryId(), (long)this.getVocabularyId());
            categoriesSearchContainer.setTotal(categoriesCount);
            categories = AssetCategoryServiceUtil.getVocabularyCategories((long)scopeGroupId, (long)this.getCategoryId(), (long)this.getVocabularyId(), (int)categoriesSearchContainer.getStart(), (int)categoriesSearchContainer.getEnd(), (OrderByComparator)categoriesSearchContainer.getOrderByComparator());
        }
        categoriesSearchContainer.setResults(categories);
        this._categoriesSearchContainer = categoriesSearchContainer;
        return this._categoriesSearchContainer;
    }

    public AssetCategory getCategory() {
        if (this._category != null) {
            return this._category;
        }
        long categoryId = this.getCategoryId();
        if (categoryId > 0L) {
            this._category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
        }
        return this._category;
    }

    public long getCategoryId() {
        if (this._categoryId != null) {
            return this._categoryId;
        }
        this._categoryId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"categoryId");
        return this._categoryId;
    }

    public String getDisplayStyle() {
        if (this.isFlattenedNavigationAllowed()) {
            this._displayStyle = "list";
        }
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getEditCategoryRedirect() {
        PortletURL backURL = this._renderResponse.createRenderURL();
        long parentCategoryId = BeanParamUtil.getLong((Object)this.getCategory(), (HttpServletRequest)this._httpServletRequest, (String)"parentCategoryId");
        backURL.setParameter("mvcPath", "/view_categories.jsp");
        if (parentCategoryId > 0L) {
            backURL.setParameter("categoryId", String.valueOf(parentCategoryId));
        }
        if (this.getVocabularyId() > 0L) {
            backURL.setParameter("vocabularyId", String.valueOf(this.getVocabularyId()));
        }
        return backURL.toString();
    }

    public String getNavigation() {
        if (this._navigation != null) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"all");
        return this._navigation;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public String getSelectCategoryURL() throws Exception {
        if (this._selectCategoryURL != null) {
            return this._selectCategoryURL;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List vocabularies = AssetVocabularyServiceUtil.getGroupVocabularies((long)themeDisplay.getScopeGroupId());
        PortletURL selectCategoryURL = PortletProviderUtil.getPortletURL((HttpServletRequest)this._httpServletRequest, (String)AssetCategory.class.getName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
        selectCategoryURL.setParameter("allowedSelectVocabularies", Boolean.TRUE.toString());
        selectCategoryURL.setParameter("eventName", this._renderResponse.getNamespace() + "selectCategory");
        selectCategoryURL.setParameter("singleSelect", Boolean.TRUE.toString());
        selectCategoryURL.setParameter("vocabularyIds", ListUtil.toString((List)vocabularies, (Accessor)AssetVocabulary.VOCABULARY_ID_ACCESSOR));
        selectCategoryURL.setWindowState(LiferayWindowState.POP_UP);
        this._selectCategoryURL = selectCategoryURL.toString();
        return this._selectCategoryURL;
    }

    public SearchContainer getVocabulariesSearchContainer() throws PortalException {
        if (this._vocabulariesSearchContainer != null) {
            return this._vocabulariesSearchContainer;
        }
        SearchContainer vocabulariesSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this._renderResponse.createRenderURL(), null, "there-are-no-vocabularies");
        vocabulariesSearchContainer.setOrderByCol("create-date");
        String orderByType = this.getOrderByType();
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        AssetVocabularyCreateDateComparator orderByComparator = new AssetVocabularyCreateDateComparator(orderByAsc);
        vocabulariesSearchContainer.setOrderByComparator((OrderByComparator)orderByComparator);
        vocabulariesSearchContainer.setOrderByType(orderByType);
        EmptyOnClickRowChecker emptyOnClickRowChecker = new EmptyOnClickRowChecker((PortletResponse)this._renderResponse);
        StringBundler sb = new StringBundler(5);
        sb.append("^(?!.*");
        sb.append(this._renderResponse.getNamespace());
        sb.append("redirect).*(/vocabulary/");
        sb.append(this.getVocabularyId());
        sb.append(")");
        emptyOnClickRowChecker.setRememberCheckBoxStateURLRegex(sb.toString());
        vocabulariesSearchContainer.setRowChecker((RowChecker)emptyOnClickRowChecker);
        List vocabularies = null;
        int vocabulariesCount = 0;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = themeDisplay.getScopeGroupId();
        String keywords = this._getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            Sort sort = new Sort("createDate", 6, orderByAsc);
            AssetVocabularyDisplay assetVocabularyDisplay = AssetVocabularyServiceUtil.searchVocabulariesDisplay((long)scopeGroupId, (String)keywords, (boolean)true, (int)vocabulariesSearchContainer.getStart(), (int)vocabulariesSearchContainer.getEnd(), (Sort)sort);
            vocabulariesCount = assetVocabularyDisplay.getTotal();
            vocabulariesSearchContainer.setTotal(vocabulariesCount);
            vocabularies = assetVocabularyDisplay.getVocabularies();
        } else {
            vocabulariesCount = AssetVocabularyServiceUtil.getGroupVocabulariesCount((long)scopeGroupId);
            vocabulariesSearchContainer.setTotal(vocabulariesCount);
            vocabularies = AssetVocabularyServiceUtil.getGroupVocabularies((long)scopeGroupId, (boolean)true, (int)vocabulariesSearchContainer.getStart(), (int)vocabulariesSearchContainer.getEnd(), (OrderByComparator)vocabulariesSearchContainer.getOrderByComparator());
            if (vocabulariesCount == 0) {
                vocabulariesCount = AssetVocabularyServiceUtil.getGroupVocabulariesCount((long)scopeGroupId);
                vocabulariesSearchContainer.setTotal(vocabulariesCount);
            }
        }
        vocabulariesSearchContainer.setResults(vocabularies);
        this._vocabulariesSearchContainer = vocabulariesSearchContainer;
        return this._vocabulariesSearchContainer;
    }

    public AssetVocabulary getVocabulary() throws PortalException {
        if (this._vocabulary != null) {
            return this._vocabulary;
        }
        long vocabularyId = this.getVocabularyId();
        if (vocabularyId > 0L) {
            this._vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)vocabularyId);
        }
        return this._vocabulary;
    }

    public long getVocabularyId() {
        if (this._vocabularyId != null) {
            return this._vocabularyId;
        }
        this._vocabularyId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"vocabularyId");
        return this._vocabularyId;
    }

    public boolean hasPermission(AssetCategory category, String actionId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)themeDisplay.getScopeGroupId(), (String)AssetCategory.class.getName(), (long)category.getCategoryId(), (String)"com_liferay_asset_categories_admin_web_portlet_AssetCategoriesAdminPortlet", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return AssetCategoryPermission.contains((PermissionChecker)permissionChecker, (AssetCategory)category, (String)actionId);
    }

    public boolean hasPermission(AssetVocabulary vocabulary, String actionId) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)themeDisplay.getScopeGroupId(), (String)AssetVocabulary.class.getName(), (long)vocabulary.getVocabularyId(), (String)"com_liferay_asset_categories_admin_web_portlet_AssetCategoriesAdminPortlet", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return AssetVocabularyPermission.contains((PermissionChecker)permissionChecker, (AssetVocabulary)vocabulary, (String)actionId);
    }

    public boolean isFlattenedNavigationAllowed() {
        return StringUtil.equals((String)this._assetCategoriesAdminWebConfiguration.categoryNavigationDisplayStyle(), (String)"flattened-tree");
    }

    public boolean isShowCategoriesAddButton() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return AssetCategoriesPermission.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (String)"com.liferay.asset.categories", (String)"com_liferay_asset_categories_admin_web_portlet_AssetCategoriesAdminPortlet", (long)themeDisplay.getSiteGroupId(), (String)"ADD_CATEGORY");
    }

    private PortletURL _getIteratorURL() {
        PortletURL currentURL = PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse);
        PortletURL iteratorURL = this._renderResponse.createRenderURL();
        iteratorURL.setParameter("mvcPath", "/view_categories.jsp");
        iteratorURL.setParameter("redirect", currentURL.toString());
        iteratorURL.setParameter("navigation", this.getNavigation());
        if (!this.isFlattenedNavigationAllowed()) {
            iteratorURL.setParameter("categoryId", String.valueOf(this.getCategoryId()));
        }
        iteratorURL.setParameter("vocabularyId", String.valueOf(this.getVocabularyId()));
        iteratorURL.setParameter("displayStyle", this.getDisplayStyle());
        iteratorURL.setParameter("keywords", this._getKeywords());
        return iteratorURL;
    }

    private String _getKeywords() {
        if (Validator.isNotNull((String)this._keywords)) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)(this.isFlattenedNavigationAllowed() ? "path" : "create-date"));
        return this._orderByCol;
    }
}

