/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.browser.web.internal.servlet.taglib.clay;

import com.liferay.asset.browser.web.internal.display.context.AssetBrowserDisplayContext;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;

public class AssetEntryVerticalCard
implements VerticalCard {
    private final AssetBrowserDisplayContext _assetBrowserDisplayContext;
    private final AssetEntry _assetEntry;
    private final AssetRenderer _assetRenderer;
    private final AssetRendererFactory _assetRendererFactory;
    private final RenderRequest _renderRequest;
    private final ThemeDisplay _themeDisplay;

    public AssetEntryVerticalCard(AssetEntry assetEntry, RenderRequest renderRequest, AssetBrowserDisplayContext assetBrowserDisplayContext) {
        this._assetEntry = assetEntry;
        this._renderRequest = renderRequest;
        this._assetBrowserDisplayContext = assetBrowserDisplayContext;
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._assetRenderer = assetEntry.getAssetRenderer();
        this._assetRendererFactory = this._assetBrowserDisplayContext.getAssetRendererFactory();
    }

    public Map<String, String> getData() {
        if (this._assetBrowserDisplayContext.isMultipleSelection()) {
            return null;
        }
        if (this._assetEntry.getEntryId() == this._assetBrowserDisplayContext.getRefererAssetEntryId()) {
            return null;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("assetclassname", this._assetEntry.getClassName());
        data.put("assetclasspk", String.valueOf(this._assetEntry.getClassPK()));
        data.put("assettitle", this._assetRenderer.getTitle(this._themeDisplay.getLocale()));
        data.put("assettype", this._assetRendererFactory.getTypeName(this._themeDisplay.getLocale(), this._assetBrowserDisplayContext.getSubtypeSelectionId()));
        data.put("entityid", String.valueOf(this._assetEntry.getEntryId()));
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._assetEntry.getGroupId());
        if (group != null) {
            try {
                data.put("groupdescriptivename", group.getDescriptiveName(this._themeDisplay.getLocale()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return data;
    }

    public String getElementClasses() {
        if (this._assetEntry.getEntryId() != this._assetBrowserDisplayContext.getRefererAssetEntryId()) {
            return "card-interactive card-interactive-secondary selector-button";
        }
        return "";
    }

    public String getIcon() {
        return this._assetRendererFactory.getIconCssClass();
    }

    public String getImageSrc() {
        try {
            return this._assetRenderer.getThumbnailPath((PortletRequest)this._renderRequest);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSubtitle() {
        if (Validator.isNull((String)this._assetBrowserDisplayContext.getTypeSelection())) {
            return HtmlUtil.escape((String)this._assetRendererFactory.getTypeName(this._themeDisplay.getLocale(), this._assetBrowserDisplayContext.getSubtypeSelectionId()));
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._assetEntry.getGroupId());
        try {
            return HtmlUtil.escape((String)group.getDescriptiveName(this._themeDisplay.getLocale()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTitle() {
        return this._assetRenderer.getTitle(this._themeDisplay.getLocale());
    }

    public boolean isSelectable() {
        return this._assetBrowserDisplayContext.isMultipleSelection();
    }
}

