/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.browser.web.internal.display.context;

import com.liferay.asset.browser.web.internal.display.context.AssetBrowserDisplayContext;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.util.AssetHelper;
import com.liferay.frontend.taglib.clay.servlet.taglib.display.context.SearchContainerManagementToolbarDisplayContext;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class AssetBrowserManagementToolbarDisplayContext
extends SearchContainerManagementToolbarDisplayContext {
    private final AssetBrowserDisplayContext _assetBrowserDisplayContext;
    private final AssetHelper _assetHelper;
    private final ThemeDisplay _themeDisplay;

    public AssetBrowserManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, AssetBrowserDisplayContext assetBrowserDisplayContext) {
        super(liferayPortletRequest, liferayPortletResponse, httpServletRequest, (SearchContainer)assetBrowserDisplayContext.getAssetBrowserSearch());
        this._assetBrowserDisplayContext = assetBrowserDisplayContext;
        this._assetHelper = (AssetHelper)httpServletRequest.getAttribute("ASSET_HELPER");
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getComponentId() {
        return "assetBrowserManagementToolbar";
    }

    public CreationMenu getCreationMenu() {
        if (!this._assetBrowserDisplayContext.isShowAddButton()) {
            return null;
        }
        final String addButtonURL = this._getAddButtonURL();
        if (Validator.isNull((String)addButtonURL)) {
            return null;
        }
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref((Object)addButtonURL);
                    dropdownItem.setLabel(LanguageUtil.format((HttpServletRequest)AssetBrowserManagementToolbarDisplayContext.this.request, (String)"add-x", (Object)AssetBrowserManagementToolbarDisplayContext.this._getAddButtonLabel(), (boolean)false));
                });
            }
        };
    }

    public List<DropdownItem> getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                long[] groupIds;
                this.add(dropdownItem -> {
                    dropdownItem.setActive(AssetBrowserManagementToolbarDisplayContext.this._assetBrowserDisplayContext.getGroupId() == 0L);
                    dropdownItem.setHref(AssetBrowserManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"groupId", 0});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetBrowserManagementToolbarDisplayContext.this.request, (String)"all"));
                });
                for (long groupId : groupIds = AssetBrowserManagementToolbarDisplayContext.this._assetBrowserDisplayContext.getSelectedGroupIds()) {
                    Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
                    if (group == null) continue;
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(AssetBrowserManagementToolbarDisplayContext.this._assetBrowserDisplayContext.getGroupId() == groupId);
                        dropdownItem.setHref(AssetBrowserManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"groupId", groupId});
                        dropdownItem.setLabel(HtmlUtil.escape((String)group.getDescriptiveName(AssetBrowserManagementToolbarDisplayContext.this._themeDisplay.getLocale())));
                    });
                }
            }
        };
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public String getSearchContainerId() {
        return "selectAssetEntries";
    }

    public Boolean isDisabled() {
        return false;
    }

    public Boolean isSelectable() {
        return this._assetBrowserDisplayContext.isMultipleSelection();
    }

    protected String[] getDisplayViews() {
        return new String[]{"list", "descriptive", "icon"};
    }

    protected String getFilterNavigationDropdownItemsLabel() {
        return LanguageUtil.get((HttpServletRequest)this.request, (String)"sites");
    }

    protected String[] getOrderByKeys() {
        return new String[]{"title", "modified-date"};
    }

    private String _getAddButtonLabel() {
        AssetRendererFactory assetRendererFactory = this._assetBrowserDisplayContext.getAssetRendererFactory();
        if (assetRendererFactory.isSupportsClassTypes() && this._assetBrowserDisplayContext.getSubtypeSelectionId() > 0L) {
            return assetRendererFactory.getTypeName(this._themeDisplay.getLocale(), this._assetBrowserDisplayContext.getSubtypeSelectionId());
        }
        return assetRendererFactory.getTypeName(this._themeDisplay.getLocale());
    }

    private String _getAddButtonURL() {
        long groupId = this._assetBrowserDisplayContext.getGroupId();
        if (groupId == 0L) {
            groupId = this._themeDisplay.getScopeGroupId();
        }
        AssetRendererFactory assetRendererFactory = this._assetBrowserDisplayContext.getAssetRendererFactory();
        PortletURL addPortletURL = null;
        try {
            addPortletURL = assetRendererFactory.isSupportsClassTypes() && this._assetBrowserDisplayContext.getSubtypeSelectionId() > 0L ? this._assetHelper.getAddPortletURL(this.liferayPortletRequest, this.liferayPortletResponse, groupId, this._assetBrowserDisplayContext.getTypeSelection(), this._assetBrowserDisplayContext.getSubtypeSelectionId(), null, null, this.getPortletURL().toString()) : this._assetHelper.getAddPortletURL(this.liferayPortletRequest, this.liferayPortletResponse, groupId, this._assetBrowserDisplayContext.getTypeSelection(), 0L, null, null, this.getPortletURL().toString());
        }
        catch (Exception e) {
            return "";
        }
        if (addPortletURL == null) {
            return "";
        }
        addPortletURL.setParameter("groupId", String.valueOf(groupId));
        return HttpUtil.addParameter((String)addPortletURL.toString(), (String)"refererPlid", (long)this._themeDisplay.getPlid());
    }
}

