/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.browser.web.internal.display.context;

import com.liferay.asset.browser.web.internal.configuration.AssetBrowserWebConfigurationValues;
import com.liferay.asset.browser.web.internal.search.AddAssetEntryChecker;
import com.liferay.asset.browser.web.internal.search.AssetBrowserSearch;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.util.AssetHelper;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class AssetBrowserDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(AssetBrowserDisplayContext.class);
    private final AssetHelper _assetHelper;
    private AssetRendererFactory _assetRendererFactory;
    private long[] _classNameIds;
    private String _displayStyle;
    private String _eventName;
    private Long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private Boolean _multipleSelection;
    private String _orderByCol;
    private String _orderByType;
    private Long _refererAssetEntryId;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private Boolean _showAddButton;
    private Boolean _showNonindexable;
    private Boolean _showScheduled;
    private Long _subtypeSelectionId;
    private String _typeSelection;

    public AssetBrowserDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._assetHelper = (AssetHelper)renderRequest.getAttribute("ASSET_HELPER");
    }

    public AssetBrowserSearch getAssetBrowserSearch() {
        AssetBrowserSearch assetBrowserSearch = new AssetBrowserSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        if (this.isMultipleSelection()) {
            assetBrowserSearch.setRowChecker((RowChecker)new AddAssetEntryChecker(this._renderResponse, this.getRefererAssetEntryId()));
        }
        assetBrowserSearch.setOrderByCol(this._getOrderByCol());
        assetBrowserSearch.setOrderByType(this.getOrderByType());
        if (AssetBrowserWebConfigurationValues.SEARCH_WITH_DATABASE) {
            long[] subtypeSelectionIds = null;
            if (this.getSubtypeSelectionId() > 0L) {
                subtypeSelectionIds = new long[]{this.getSubtypeSelectionId()};
            }
            int total = AssetEntryLocalServiceUtil.getEntriesCount((long[])this._getFilterGroupIds(), (long[])this._getClassNameIds(), (long[])subtypeSelectionIds, (String)this._getKeywords(), (String)this._getKeywords(), (String)this._getKeywords(), (String)this._getKeywords(), (Boolean)this._getListable(), (boolean)false, (boolean)false);
            assetBrowserSearch.setTotal(total);
            List assetEntries = AssetEntryLocalServiceUtil.getEntries((long[])this._getFilterGroupIds(), (long[])this._getClassNameIds(), (long[])subtypeSelectionIds, (String)this._getKeywords(), (String)this._getKeywords(), (String)this._getKeywords(), (String)this._getKeywords(), (Boolean)this._getListable(), (boolean)false, (boolean)false, (int)assetBrowserSearch.getStart(), (int)assetBrowserSearch.getEnd(), (String)"modifiedDate", (String)"", (String)this.getOrderByType(), (String)"");
            assetBrowserSearch.setResults(assetEntries);
            return assetBrowserSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Sort sort = null;
        boolean orderByAsc = false;
        if (Objects.equals(this.getOrderByType(), "asc")) {
            orderByAsc = true;
        }
        if (Objects.equals(this._getOrderByCol(), "modified-date")) {
            sort = new Sort("modified", 6, orderByAsc);
        } else if (Objects.equals(this._getOrderByCol(), "title")) {
            String sortFieldName = Field.getSortableFieldName((String)"localized_title_".concat(themeDisplay.getLanguageId()));
            sort = new Sort(sortFieldName, 3, orderByAsc);
        }
        int total = (int)AssetEntryLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])this._getFilterGroupIds(), (long)themeDisplay.getUserId(), (long[])this._getClassNameIds(), (long)this.getSubtypeSelectionId(), (String)this._getKeywords(), (boolean)this._isShowNonindexable(), (int[])this._getStatuses());
        assetBrowserSearch.setTotal(total);
        Hits hits = AssetEntryLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])this._getFilterGroupIds(), (long)themeDisplay.getUserId(), (long[])this._getClassNameIds(), (long)this.getSubtypeSelectionId(), (String)this._getKeywords(), (boolean)this._isShowNonindexable(), (int[])this._getStatuses(), (int)assetBrowserSearch.getStart(), (int)assetBrowserSearch.getEnd(), (Sort)sort);
        List assetEntries = this._assetHelper.getAssetEntries(hits);
        assetBrowserSearch.setResults(assetEntries);
        return assetBrowserSearch;
    }

    public AssetRendererFactory getAssetRendererFactory() {
        if (this._assetRendererFactory != null) {
            return this._assetRendererFactory;
        }
        this._assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getTypeSelection());
        return this._assetRendererFactory;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getEventName() {
        if (this._eventName != null) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"eventName", (String)(this._renderResponse.getNamespace() + "selectAsset"));
        return this._eventName;
    }

    public long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId");
        return this._groupId;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        long[] selectedGroupIds;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        long selectedGroupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"selectedGroupId");
        if (selectedGroupId > 0L) {
            portletURL.setParameter("selectedGroupId", String.valueOf(selectedGroupId));
        }
        if ((selectedGroupIds = this.getSelectedGroupIds()).length > 0) {
            portletURL.setParameter("selectedGroupIds", StringUtil.merge((long[])selectedGroupIds));
        }
        portletURL.setParameter("refererAssetEntryId", String.valueOf(this.getRefererAssetEntryId()));
        portletURL.setParameter("typeSelection", this.getTypeSelection());
        portletURL.setParameter("subtypeSelectionId", String.valueOf(this.getSubtypeSelectionId()));
        if (this._getListable() != null) {
            portletURL.setParameter("listable", String.valueOf(this._getListable()));
        }
        if (this.isMultipleSelection()) {
            portletURL.setParameter("multipleSelection", Boolean.TRUE.toString());
        }
        if (this.isShowAddButton()) {
            portletURL.setParameter("showAddButton", Boolean.TRUE.toString());
        }
        portletURL.setParameter("showNonindexable", String.valueOf(this._isShowNonindexable()));
        portletURL.setParameter("showScheduled", String.valueOf(this._isShowScheduled()));
        portletURL.setParameter("eventName", this.getEventName());
        return portletURL;
    }

    public long getRefererAssetEntryId() {
        if (this._refererAssetEntryId != null) {
            return this._refererAssetEntryId;
        }
        this._refererAssetEntryId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"refererAssetEntryId");
        return this._refererAssetEntryId;
    }

    public long[] getSelectedGroupIds() {
        long[] selectedGroupIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"selectedGroupIds"), (long)0L);
        if (selectedGroupIds.length > 0) {
            return selectedGroupIds;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long selectedGroupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"selectedGroupId");
        try {
            return PortalUtil.getSharedContentSiteGroupIds((long)themeDisplay.getCompanyId(), (long)selectedGroupId, (long)themeDisplay.getUserId());
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return new long[0];
        }
    }

    public long getSubtypeSelectionId() {
        if (this._subtypeSelectionId != null) {
            return this._subtypeSelectionId;
        }
        this._subtypeSelectionId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"subtypeSelectionId");
        return this._subtypeSelectionId;
    }

    public String getTypeSelection() {
        if (this._typeSelection != null) {
            return this._typeSelection;
        }
        this._typeSelection = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"typeSelection");
        return this._typeSelection;
    }

    public boolean isMultipleSelection() {
        if (this._multipleSelection != null) {
            return this._multipleSelection;
        }
        this._multipleSelection = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"multipleSelection");
        return this._multipleSelection;
    }

    public boolean isShowAddButton() {
        if (this._showAddButton != null) {
            return this._showAddButton;
        }
        this._showAddButton = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"showAddButton");
        return this._showAddButton;
    }

    private long[] _getClassNameIds() {
        if (this._classNameIds != null) {
            return this._classNameIds;
        }
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null) {
            this._classNameIds = new long[]{assetRendererFactory.getClassNameId()};
        }
        return this._classNameIds;
    }

    private long[] _getFilterGroupIds() {
        long[] filterGroupIds = this.getSelectedGroupIds();
        if (this.getGroupId() > 0L) {
            filterGroupIds = new long[]{this.getGroupId()};
        }
        return filterGroupIds;
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    private Boolean _getListable() {
        Boolean listable = null;
        String listableValue = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"listable", null);
        if (Validator.isNotNull((String)listableValue)) {
            listable = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"listable", (boolean)true);
        }
        return listable;
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    private int[] _getStatuses() {
        int[] statuses = new int[]{0};
        if (this._isShowScheduled()) {
            statuses = new int[]{0, 7};
        }
        return statuses;
    }

    private boolean _isShowNonindexable() {
        if (this._showNonindexable != null) {
            return this._showNonindexable;
        }
        this._showNonindexable = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"showNonindexable");
        return this._showNonindexable;
    }

    private boolean _isShowScheduled() {
        if (this._showScheduled != null) {
            return this._showScheduled;
        }
        this._showScheduled = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"showScheduled");
        return this._showScheduled;
    }
}

