/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.browser.web.internal.display.context;

import com.liferay.asset.browser.web.internal.configuration.AssetBrowserWebConfigurationValues;
import com.liferay.asset.browser.web.internal.search.AssetBrowserSearch;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.util.AssetHelper;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class AssetBrowserDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(AssetBrowserDisplayContext.class);
    private final AssetHelper _assetHelper;
    private AssetRendererFactory _assetRendererFactory;
    private String _displayStyle;
    private String _eventName;
    private Long _groupId;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private Long _refererAssetEntryId;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private Boolean _showNonindexable;
    private Boolean _showScheduled;
    private Long _subtypeSelectionId;
    private String _typeSelection;

    public AssetBrowserDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._assetHelper = (AssetHelper)renderRequest.getAttribute("ASSET_HELPER");
    }

    public String getAddButtonURL() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = this._getGroupId();
        if (groupId == 0L) {
            groupId = themeDisplay.getScopeGroupId();
        }
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)this._renderRequest);
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)this._renderResponse);
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL addPortletURL = null;
        try {
            addPortletURL = assetRendererFactory.isSupportsClassTypes() && this.getSubtypeSelectionId() > 0L ? this._assetHelper.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, groupId, this.getTypeSelection(), this.getSubtypeSelectionId(), null, null, this.getPortletURL().toString()) : this._assetHelper.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, groupId, this.getTypeSelection(), 0L, null, null, this.getPortletURL().toString());
        }
        catch (Exception e) {
            return "";
        }
        if (addPortletURL == null) {
            return "";
        }
        addPortletURL.setParameter("groupId", String.valueOf(groupId));
        return HttpUtil.addParameter((String)addPortletURL.toString(), (String)"refererPlid", (long)themeDisplay.getPlid());
    }

    public AssetBrowserSearch getAssetBrowserSearch() {
        AssetBrowserSearch assetBrowserSearch = new AssetBrowserSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        int total = this.getTotalItems();
        assetBrowserSearch.setTotal(total);
        if (AssetBrowserWebConfigurationValues.SEARCH_WITH_DATABASE) {
            List assetEntries = AssetEntryLocalServiceUtil.getEntries((long[])this._getFilterGroupIds(), (long[])new long[]{assetRendererFactory.getClassNameId()}, (String)this._getKeywords(), (String)this._getKeywords(), (String)this._getKeywords(), (String)this._getKeywords(), (Boolean)this._getListable(), (boolean)false, (boolean)false, (int)assetBrowserSearch.getStart(), (int)assetBrowserSearch.getEnd(), (String)"modifiedDate", (String)"", (String)this.getOrderByType(), (String)"");
            assetBrowserSearch.setResults(assetEntries);
        } else {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Sort sort = null;
            boolean orderByAsc = false;
            if (Objects.equals(this.getOrderByType(), "asc")) {
                orderByAsc = true;
            }
            if (Objects.equals(this._getOrderByCol(), "modified-date")) {
                sort = new Sort("modified", 6, orderByAsc);
            } else if (Objects.equals(this._getOrderByCol(), "title")) {
                String sortFieldName = Field.getSortableFieldName((String)"localized_title_".concat(themeDisplay.getLanguageId()));
                sort = new Sort(sortFieldName, 3, orderByAsc);
            }
            Hits hits = AssetEntryLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])this._getFilterGroupIds(), (long)themeDisplay.getUserId(), (String)assetRendererFactory.getClassName(), (long)this.getSubtypeSelectionId(), (String)this._getKeywords(), (boolean)this._isShowNonindexable(), (int[])this._getStatuses(), (int)assetBrowserSearch.getStart(), (int)assetBrowserSearch.getEnd(), (Sort)sort);
            List assetEntries = this._assetHelper.getAssetEntries(hits);
            assetBrowserSearch.setResults(assetEntries);
        }
        return assetBrowserSearch;
    }

    public AssetRendererFactory getAssetRendererFactory() {
        if (this._assetRendererFactory != null) {
            return this._assetRendererFactory;
        }
        this._assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getTypeSelection());
        return this._assetRendererFactory;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() {
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref((Object)AssetBrowserDisplayContext.this.getAddButtonURL());
                    dropdownItem.setLabel(LanguageUtil.format((HttpServletRequest)AssetBrowserDisplayContext.this._request, (String)"add-x", (Object)AssetBrowserDisplayContext.this._getAddButtonLabel(), (boolean)false));
                });
            }
        };
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._displayStyle = portalPreferences.getValue("com_liferay_asset_browser_web_portlet_AssetBrowserPortlet", "display-style", "list");
        return this._displayStyle;
    }

    public String getEventName() {
        if (this._eventName != null) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((HttpServletRequest)this._request, (String)"eventName", (String)(this._renderResponse.getNamespace() + "selectAsset"));
        return this._eventName;
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(SafeConsumer.ignore(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(AssetBrowserDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetBrowserDisplayContext.this._request, (String)"sites"));
                }));
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(AssetBrowserDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetBrowserDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)AssetBrowserDisplayContext.this.getPortletURL());
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetBrowserDisplayContext.this._request, (String)"entries"));
                });
            }
        };
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        return this._getPortletURL(false);
    }

    public long getRefererAssetEntryId() {
        if (this._refererAssetEntryId != null) {
            return this._refererAssetEntryId;
        }
        this._refererAssetEntryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"refererAssetEntryId");
        return this._refererAssetEntryId;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this._getPortletURL(true);
        return searchActionURL.toString();
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public long getSubtypeSelectionId() {
        if (this._subtypeSelectionId != null) {
            return this._subtypeSelectionId;
        }
        this._subtypeSelectionId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"subtypeSelectionId");
        return this._subtypeSelectionId;
    }

    public int getTotalItems() {
        return this._getTotal(this._getFilterGroupIds());
    }

    public String getTypeSelection() {
        if (this._typeSelection != null) {
            return this._typeSelection;
        }
        this._typeSelection = ParamUtil.getString((HttpServletRequest)this._request, (String)"typeSelection");
        return this._typeSelection;
    }

    public List<ViewTypeItem> getViewTypeItems() {
        PortletURL portletURL = this._renderResponse.createActionURL();
        portletURL.setParameter("javax.portlet.action", "changeDisplayStyle");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._request));
        return new ViewTypeItemList(portletURL, this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean isDisabledManagementBar() {
        return this._getTotal(this._getSelectedGroupIds()) <= 0;
    }

    private String _getAddButtonLabel() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory.isSupportsClassTypes() && this.getSubtypeSelectionId() > 0L) {
            return assetRendererFactory.getTypeName(themeDisplay.getLocale(), this.getSubtypeSelectionId());
        }
        return assetRendererFactory.getTypeName(themeDisplay.getLocale());
    }

    private long[] _getFilterGroupIds() {
        long[] filterGroupIds = this._getSelectedGroupIds();
        if (this._getGroupId() > 0L) {
            filterGroupIds = new long[]{this._getGroupId()};
        }
        return filterGroupIds;
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() throws PortalException {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(AssetBrowserDisplayContext.this._getGroupId() == 0L);
                    dropdownItem.setHref(AssetBrowserDisplayContext.this.getPortletURL(), new Object[]{"groupId", 0});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetBrowserDisplayContext.this._request, (String)"all"));
                });
                List groups = GroupLocalServiceUtil.getGroups((long[])AssetBrowserDisplayContext.this._getSelectedGroupIds());
                for (Group curGroup : groups) {
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setActive(AssetBrowserDisplayContext.this._getGroupId() == curGroup.getGroupId());
                        dropdownItem.setHref(AssetBrowserDisplayContext.this.getPortletURL(), new Object[]{"groupId", curGroup.getGroupId()});
                        dropdownItem.setLabel(HtmlUtil.escape((String)curGroup.getDescriptiveName(themeDisplay.getLocale())));
                    }));
                }
            }
        };
    }

    private long _getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId");
        return this._groupId;
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        return this._keywords;
    }

    private Boolean _getListable() {
        Boolean listable = null;
        String listableValue = ParamUtil.getString((HttpServletRequest)this._request, (String)"listable", null);
        if (Validator.isNotNull((String)listableValue)) {
            listable = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"listable", (boolean)true);
        }
        return listable;
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                if (!AssetBrowserWebConfigurationValues.SEARCH_WITH_DATABASE) {
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(Objects.equals(AssetBrowserDisplayContext.this._getOrderByCol(), "title"));
                        dropdownItem.setHref(AssetBrowserDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "title"});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetBrowserDisplayContext.this._request, (String)"title"));
                    });
                }
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(AssetBrowserDisplayContext.this._getOrderByCol(), "modified-date"));
                    dropdownItem.setHref(AssetBrowserDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "modified-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)AssetBrowserDisplayContext.this._request, (String)"modified-date"));
                });
            }
        };
    }

    private PortletURL _getPortletURL(boolean search) {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        if (!search && this._getKeywords() != null) {
            portletURL.setParameter("keywords", this._getKeywords());
        }
        portletURL.setParameter("groupId", String.valueOf(this._getGroupId()));
        long selectedGroupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"selectedGroupId");
        if (selectedGroupId > 0L) {
            portletURL.setParameter("selectedGroupId", String.valueOf(selectedGroupId));
        } else {
            long[] selectedGroupIds = this._getSelectedGroupIds();
            if (selectedGroupIds.length > 0) {
                portletURL.setParameter("selectedGroupIds", StringUtil.merge((long[])selectedGroupIds));
            }
        }
        portletURL.setParameter("refererAssetEntryId", String.valueOf(this.getRefererAssetEntryId()));
        portletURL.setParameter("typeSelection", this.getTypeSelection());
        portletURL.setParameter("subtypeSelectionId", String.valueOf(this.getSubtypeSelectionId()));
        if (this._getListable() != null) {
            portletURL.setParameter("listable", String.valueOf(this._getListable()));
        }
        portletURL.setParameter("showNonindexable", String.valueOf(this._isShowNonindexable()));
        portletURL.setParameter("showScheduled", String.valueOf(this._isShowScheduled()));
        portletURL.setParameter("eventName", this.getEventName());
        return portletURL;
    }

    private long[] _getSelectedGroupIds() {
        long[] selectedGroupIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)this._request, (String)"selectedGroupIds"), (long)0L);
        if (selectedGroupIds.length > 0) {
            return selectedGroupIds;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long selectedGroupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"selectedGroupId");
        try {
            return PortalUtil.getSharedContentSiteGroupIds((long)themeDisplay.getCompanyId(), (long)selectedGroupId, (long)themeDisplay.getUserId());
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return new long[0];
        }
    }

    private int[] _getStatuses() {
        int[] statuses = new int[]{0};
        if (this._isShowScheduled()) {
            statuses = new int[]{0, 7};
        }
        return statuses;
    }

    private int _getTotal(long[] groupIds) {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        if (AssetBrowserWebConfigurationValues.SEARCH_WITH_DATABASE) {
            return AssetEntryLocalServiceUtil.getEntriesCount((long[])groupIds, (long[])new long[]{assetRendererFactory.getClassNameId()}, (String)this._getKeywords(), (String)this._getKeywords(), (String)this._getKeywords(), (String)this._getKeywords(), (Boolean)this._getListable(), (boolean)false, (boolean)false);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return (int)AssetEntryLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])groupIds, (long)themeDisplay.getUserId(), (String)assetRendererFactory.getClassName(), (long)this.getSubtypeSelectionId(), (String)this._getKeywords(), (boolean)this._isShowNonindexable(), (int[])this._getStatuses());
    }

    private boolean _isShowNonindexable() {
        if (this._showNonindexable != null) {
            return this._showNonindexable;
        }
        this._showNonindexable = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"showNonindexable");
        return this._showNonindexable;
    }

    private boolean _isShowScheduled() {
        if (this._showScheduled != null) {
            return this._showScheduled;
        }
        this._showScheduled = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"showScheduled");
        return this._showScheduled;
    }
}

