/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StringUtil {
    public static <T> String merge(Collection<T> col, String delimiter) {
        if (col == null) {
            return null;
        }
        if (col.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2 * col.size());
        for (T t : col) {
            sb.append(String.valueOf(t));
            sb.append(delimiter);
        }
        int delimeterLength = delimiter.length();
        sb.setLength(sb.length() - delimeterLength);
        return sb.toString();
    }

    public static List<String> split(String s) {
        return StringUtil.split(s, ',');
    }

    public static List<String> split(String s, char delimiter) {
        int pos;
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        if ((s = s.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> elements = new ArrayList<String>();
        int offset = 0;
        while ((pos = s.indexOf(delimiter, offset)) != -1) {
            if (offset < pos) {
                elements.add(s.substring(offset, pos));
            }
            offset = pos + 1;
        }
        if (offset < s.length()) {
            elements.add(s.substring(offset));
        }
        return elements;
    }
}

